/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import org.apache.drill.exec.planner.logical.CreateTableEntry;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemSchemaFactory
implements SchemaFactory {
    static final Logger logger = LoggerFactory.getLogger(FileSystemSchemaFactory.class);
    private List<WorkspaceSchemaFactory> factories;
    private String schemaName;

    @Override
    public void registerSchemas(UserSession session, SchemaPlus parent) {
        FileSystemSchema schema = new FileSystemSchema(this.schemaName, session);
        SchemaPlus plusOfThis = parent.add(schema.getName(), schema);
        schema.setPlus(plusOfThis);
    }

    public class FileSystemSchema
    extends AbstractSchema {
        private final WorkspaceSchemaFactory.WorkspaceSchema defaultSchema;
        private final Map<String, WorkspaceSchemaFactory.WorkspaceSchema> schemaMap;

        public FileSystemSchema(String name, UserSession session) {
            super(ImmutableList.of(), name);
            this.schemaMap = Maps.newHashMap();
            for (WorkspaceSchemaFactory f : FileSystemSchemaFactory.this.factories) {
                WorkspaceSchemaFactory.WorkspaceSchema s = f.createSchema(this.getSchemaPath(), session);
                this.schemaMap.put(s.getName(), s);
            }
            this.defaultSchema = this.schemaMap.get("default");
        }

        void setPlus(SchemaPlus plusOfThis) {
            for (WorkspaceSchemaFactory.WorkspaceSchema s : this.schemaMap.values()) {
                plusOfThis.add(s.getName(), s);
            }
        }

        @Override
        public boolean showInInformationSchema() {
            return false;
        }

        @Override
        public String getTypeName() {
            return "file";
        }

        @Override
        public Table getTable(String name) {
            return this.defaultSchema.getTable(name);
        }

        @Override
        public Schema getSubSchema(String name) {
            return this.schemaMap.get(name);
        }

        @Override
        public Set<String> getSubSchemaNames() {
            return this.schemaMap.keySet();
        }

        @Override
        public Set<String> getTableNames() {
            return this.defaultSchema.getTableNames();
        }

        @Override
        public boolean isMutable() {
            return this.defaultSchema.isMutable();
        }

        @Override
        public CreateTableEntry createNewTable(String tableName) {
            return this.defaultSchema.createNewTable(tableName);
        }

        @Override
        public AbstractSchema getDefaultSchema() {
            return this.defaultSchema;
        }
    }
}

