/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.dfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.drill.exec.store.dfs.shim.DrillFileSystem;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSelection {
    static final Logger logger = LoggerFactory.getLogger(FileSelection.class);
    @JsonIgnore
    private List<FileStatus> statuses;
    public List<String> files;
    public String selectionRoot;

    public FileSelection() {
    }

    public FileSelection(List<FileStatus> statuses, String selectionRoot) {
        this.statuses = statuses;
        this.files = Lists.newArrayList();
        for (FileStatus f : statuses) {
            this.files.add(f.getPath().toString());
        }
        this.selectionRoot = selectionRoot;
    }

    public boolean containsDirectories(DrillFileSystem fs) throws IOException {
        this.init(fs);
        for (FileStatus p : this.statuses) {
            if (!p.isDir()) continue;
            return true;
        }
        return false;
    }

    public FileSelection minusDirectories(DrillFileSystem fs) throws IOException {
        this.init(fs);
        ArrayList<FileStatus> newList = Lists.newArrayList();
        for (FileStatus p : this.statuses) {
            if (p.isDir()) {
                List<FileStatus> statuses = fs.list(true, p.getPath());
                for (FileStatus s : statuses) {
                    newList.add(s);
                }
                continue;
            }
            newList.add(p);
        }
        return new FileSelection(newList, this.selectionRoot);
    }

    private void init(DrillFileSystem fs) throws IOException {
        if (this.files != null && this.statuses == null) {
            this.statuses = Lists.newArrayList();
            for (String p : this.files) {
                this.statuses.add(fs.getFileStatus(new Path(p)));
            }
        }
    }

    public static FileSelection create(DrillFileSystem fs, String parent, String path) throws IOException {
        if (!path.contains("*") && !path.contains("?")) {
            Path p = new Path(parent, FileSelection.removeLeadingSlash(path));
            FileStatus status = fs.getFileStatus(p);
            return new FileSelection(Collections.singletonList(status), p.toUri().getPath());
        }
        Path p = new Path(parent, FileSelection.removeLeadingSlash(path));
        FileStatus[] status = fs.getUnderlying().globStatus(p);
        if (status == null || status.length == 0) {
            return null;
        }
        Object[] s = p.toUri().getPath().split("/");
        String newPath = StringUtils.join(ArrayUtils.subarray((Object[])s, (int)0, (int)(s.length - 1)), "/");
        Preconditions.checkState(!newPath.contains("*") && !newPath.contains("?"), String.format("Unsupported selection path: %s", p));
        return new FileSelection(Lists.newArrayList(status), newPath);
    }

    private static String removeLeadingSlash(String path) {
        if (path.charAt(0) == '/') {
            String newPath = path.substring(1);
            return FileSelection.removeLeadingSlash(newPath);
        }
        return path;
    }
}

