/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.tools.RuleSet;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.util.PathScanner;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.planner.logical.DrillRuleSets;
import org.apache.drill.exec.planner.logical.StoragePlugins;
import org.apache.drill.exec.rpc.user.UserSession;
import org.apache.drill.exec.server.DrillbitContext;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.NamedStoragePluginConfig;
import org.apache.drill.exec.store.SchemaFactory;
import org.apache.drill.exec.store.StoragePlugin;
import org.apache.drill.exec.store.SubSchemaWrapper;
import org.apache.drill.exec.store.ischema.InfoSchemaConfig;
import org.apache.drill.exec.store.ischema.InfoSchemaStoragePlugin;
import org.apache.drill.exec.store.sys.PStore;
import org.apache.drill.exec.store.sys.PStoreConfig;
import org.apache.drill.exec.store.sys.SystemTablePlugin;
import org.apache.drill.exec.store.sys.SystemTablePluginConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoragePluginRegistry
implements Iterable<Map.Entry<String, StoragePlugin>> {
    static final Logger logger = LoggerFactory.getLogger(StoragePluginRegistry.class);
    private Map<Object, Constructor<? extends StoragePlugin>> availablePlugins = new HashMap<Object, Constructor<? extends StoragePlugin>>();
    private ConcurrentMap<String, StoragePlugin> plugins;
    private DrillbitContext context;
    private final DrillSchemaFactory schemaFactory = new DrillSchemaFactory();
    private final PStore<StoragePluginConfig> pluginSystemTable;
    private final Object updateLock = new Object();
    private volatile long lastUpdate = 0L;

    public StoragePluginRegistry(DrillbitContext context) {
        try {
            this.context = context;
            this.pluginSystemTable = context.getPersistentStoreProvider().getPStore(PStoreConfig.newJacksonBuilder(context.getConfig().getMapper(), StoragePluginConfig.class).name("sys.storage_plugins").build());
        }
        catch (IOException | RuntimeException e) {
            logger.error("Failure while loading storage plugin registry.", e);
            throw new RuntimeException("Faiure while reading and loading storage plugin configuration.", e);
        }
    }

    public void init() throws DrillbitStartupException {
        DrillConfig config = this.context.getConfig();
        Set<Class<StoragePlugin>> plugins = PathScanner.scanForImplementations(StoragePlugin.class, config.getStringList("drill.exec.storage.packages"));
        logger.debug("Loading storage plugins {}", (Object)plugins);
        for (Class clazz : plugins) {
            int i = 0;
            for (Constructor<?> c : clazz.getConstructors()) {
                Class<?>[] params = c.getParameterTypes();
                if (params.length != 3 || params[1] != DrillbitContext.class || !StoragePluginConfig.class.isAssignableFrom(params[0]) || params[2] != String.class) {
                    logger.info("Skipping StoragePlugin constructor {} for plugin class {} since it doesn't implement a [constructor(StoragePluginConfig, DrillbitContext, String)]", (Object)c, (Object)clazz);
                    continue;
                }
                this.availablePlugins.put(params[0], c);
                ++i;
            }
            if (i != 0) continue;
            logger.debug("Skipping registration of StoragePlugin {} as it doesn't have a constructor with the parameters of (StorangePluginConfig, Config)", (Object)clazz.getCanonicalName());
        }
        this.plugins = Maps.newConcurrentMap();
        this.plugins.putAll(this.createPlugins());
    }

    private Map<String, StoragePlugin> createPlugins() throws DrillbitStartupException {
        try {
            if (!this.pluginSystemTable.iterator().hasNext()) {
                logger.info("No storage plugin instances configured in persistent store, loading bootstrap configuration.");
                Set<URL> urls = PathScanner.forResource("bootstrap-storage-plugins.json", false, Resources.class.getClassLoader());
                if (urls != null && !urls.isEmpty()) {
                    logger.info("Loading the storage plugin configs from URLs {}.", (Object)urls);
                    HashMap<String, URL> pluginURLMap = Maps.newHashMap();
                    for (URL url : urls) {
                        String pluginsData = Resources.toString(url, Charsets.UTF_8);
                        StoragePlugins plugins = this.context.getConfig().getMapper().readValue(pluginsData, StoragePlugins.class);
                        for (Map.Entry<String, StoragePluginConfig> config : plugins) {
                            if (!this.pluginSystemTable.putIfAbsent(config.getKey(), config.getValue())) {
                                logger.warn("Duplicate plugin instance '{}' defined in [{}, {}], ignoring the later one.", config.getKey(), pluginURLMap.get(config.getKey()), url);
                                continue;
                            }
                            pluginURLMap.put(config.getKey(), url);
                        }
                    }
                } else {
                    throw new IOException("Failure finding bootstrap-storage-plugins.json");
                }
            }
            HashMap<String, StoragePlugin> activePlugins = new HashMap<String, StoragePlugin>();
            for (Map.Entry entry : this.pluginSystemTable) {
                try {
                    if (!((StoragePluginConfig)entry.getValue()).isEnabled()) continue;
                    StoragePlugin plugin = this.create((String)entry.getKey(), (StoragePluginConfig)entry.getValue());
                    activePlugins.put((String)entry.getKey(), plugin);
                }
                catch (ExecutionSetupException e) {
                    logger.error("Failure while setting up StoragePlugin with name: '{}'.", entry.getKey(), (Object)e);
                }
            }
            activePlugins.put("INFORMATION_SCHEMA", new InfoSchemaStoragePlugin(new InfoSchemaConfig(), this.context, "INFORMATION_SCHEMA"));
            activePlugins.put("sys", new SystemTablePlugin(SystemTablePluginConfig.INSTANCE, this.context, "sys"));
            return activePlugins;
        }
        catch (IOException e) {
            logger.error("Failure setting up storage plugins.  Drillbit exiting.", e);
            throw new IllegalStateException(e);
        }
    }

    public StoragePlugin createOrUpdate(String name, StoragePluginConfig config, boolean persist) throws ExecutionSetupException {
        StoragePlugin oldPlugin = (StoragePlugin)this.plugins.get(name);
        StoragePlugin newPlugin = this.create(name, config);
        boolean ok = true;
        if (oldPlugin != null) {
            ok = config.isEnabled() ? this.plugins.replace(name, oldPlugin, newPlugin) : this.plugins.remove(name, oldPlugin);
        } else if (config.isEnabled()) {
            boolean bl = ok = null == this.plugins.putIfAbsent(name, newPlugin);
        }
        if (!ok) {
            throw new ExecutionSetupException("Two processes tried to change a plugin at the same time.");
        }
        if (persist) {
            this.pluginSystemTable.put(name, config);
        }
        return newPlugin;
    }

    public StoragePlugin getPlugin(String name) throws ExecutionSetupException {
        StoragePlugin plugin = (StoragePlugin)this.plugins.get(name);
        if (name.equals("sys") || name.equals("INFORMATION_SCHEMA")) {
            return plugin;
        }
        StoragePluginConfig config = this.pluginSystemTable.get(name);
        if (config == null) {
            if (plugin != null) {
                this.plugins.remove(name);
            }
            return null;
        }
        if (plugin == null || !plugin.getConfig().equals(config)) {
            plugin = this.createOrUpdate(name, config, false);
        }
        return plugin;
    }

    public StoragePlugin getPlugin(StoragePluginConfig config) throws ExecutionSetupException {
        if (config instanceof NamedStoragePluginConfig) {
            return this.getPlugin(((NamedStoragePluginConfig)config).name);
        }
        return this.create(null, config);
    }

    private StoragePlugin create(String name, StoragePluginConfig pluginConfig) throws ExecutionSetupException {
        StoragePlugin plugin = null;
        Constructor<? extends StoragePlugin> c = this.availablePlugins.get(pluginConfig.getClass());
        if (c == null) {
            throw new ExecutionSetupException(String.format("Failure finding StoragePlugin constructor for config %s", pluginConfig));
        }
        try {
            plugin = c.newInstance(pluginConfig, this.context, name);
            return plugin;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            Exception t;
            Throwable throwable = t = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
            if (t instanceof ExecutionSetupException) {
                throw (ExecutionSetupException)t;
            }
            throw new ExecutionSetupException(String.format("Failure setting up new storage plugin configuration for config %s", pluginConfig), t);
        }
    }

    @Override
    public Iterator<Map.Entry<String, StoragePlugin>> iterator() {
        return this.plugins.entrySet().iterator();
    }

    public RuleSet getStoragePluginRuleSet() {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (StoragePlugin plugin : this.plugins.values()) {
            Set rules = plugin.getOptimizerRules();
            if (rules == null || rules.size() <= 0) continue;
            setBuilder.addAll((Iterable)rules);
        }
        return DrillRuleSets.create(setBuilder.build());
    }

    public DrillSchemaFactory getSchemaFactory() {
        return this.schemaFactory;
    }

    public class DrillSchemaFactory
    implements SchemaFactory {
        @Override
        public void registerSchemas(UserSession session, SchemaPlus parent) {
            Stopwatch watch = new Stopwatch();
            watch.start();
            try {
                HashSet<String> currentPluginNames = Sets.newHashSet(StoragePluginRegistry.this.plugins.keySet());
                for (Map.Entry config : StoragePluginRegistry.this.pluginSystemTable) {
                    if (!((StoragePluginConfig)config.getValue()).isEnabled()) continue;
                    StoragePluginRegistry.this.getPlugin((String)config.getKey());
                    currentPluginNames.remove(config.getKey());
                }
                for (String pluginName : currentPluginNames) {
                    if (pluginName.equals("sys") || pluginName.equals("INFORMATION_SCHEMA")) continue;
                    StoragePluginRegistry.this.plugins.remove(pluginName);
                }
                for (StoragePlugin plugin : StoragePluginRegistry.this.plugins.values()) {
                    plugin.registerSchemas(session, parent);
                }
            }
            catch (ExecutionSetupException e) {
                throw new DrillRuntimeException("Failure while updating storage plugins", e);
            }
            ArrayList<SchemaPlus> secondLevelSchemas = Lists.newArrayList();
            for (String firstLevelSchemaName : parent.getSubSchemaNames()) {
                SchemaPlus firstLevelSchema = parent.getSubSchema(firstLevelSchemaName);
                for (String secondLevelSchemaName : firstLevelSchema.getSubSchemaNames()) {
                    secondLevelSchemas.add(firstLevelSchema.getSubSchema(secondLevelSchemaName));
                }
            }
            for (SchemaPlus schema : secondLevelSchemas) {
                AbstractSchema drillSchema;
                try {
                    drillSchema = schema.unwrap(AbstractSchema.class);
                }
                catch (ClassCastException e) {
                    throw new RuntimeException(String.format("Schema '%s' is not expected under root schema", schema.getName()));
                }
                SubSchemaWrapper wrapper = new SubSchemaWrapper(drillSchema);
                parent.add(wrapper.getName(), wrapper);
            }
            logger.debug("Took {} ms to register schemas.", (Object)watch.elapsed(TimeUnit.MILLISECONDS));
        }
    }
}

