/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.eigenbase.sql.SqlLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryOptionManager
implements OptionManager {
    static final Logger logger = LoggerFactory.getLogger(SessionOptionManager.class);
    private Map<String, OptionValue> options = Maps.newConcurrentMap();
    private OptionManager sessionOptions;

    public QueryOptionManager(OptionManager sessionOptions) {
        this.sessionOptions = sessionOptions;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        return Iterables.concat(this.sessionOptions, this.options.values()).iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        OptionValue opt = this.options.get(name);
        if (opt == null && this.sessionOptions != null) {
            return this.sessionOptions.getOption(name);
        }
        return opt;
    }

    @Override
    public void setOption(OptionValue value) {
        this.sessionOptions.getAdmin().validate(value);
        this.setValidatedOption(value);
    }

    @Override
    public void setOption(String name, SqlLiteral literal, OptionValue.OptionType type) {
        OptionValue val = this.sessionOptions.getAdmin().validate(name, literal);
        val.type = type;
        this.setValidatedOption(val);
    }

    private void setValidatedOption(OptionValue value) {
        if (value.type == OptionValue.OptionType.QUERY) {
            this.options.put(value.name, value);
        } else {
            this.sessionOptions.setOption(value);
        }
    }

    @Override
    public OptionManager.OptionAdmin getAdmin() {
        return this.sessionOptions.getAdmin();
    }

    @Override
    public OptionList getOptionList() {
        OptionList list = new OptionList();
        for (OptionValue o : this.options.values()) {
            list.add(o);
        }
        return list;
    }
}

