/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server.options;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValue;
import org.apache.drill.exec.server.options.SetOptionException;
import org.eigenbase.sql.SqlLiteral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentOptionManager
implements OptionManager {
    static final Logger logger = LoggerFactory.getLogger(FragmentOptionManager.class);
    ImmutableMap<String, OptionValue> options;
    OptionManager systemOptions;

    public FragmentOptionManager(OptionManager systemOptions, OptionList options) {
        HashMap<String, OptionValue> tmp = Maps.newHashMap();
        for (OptionValue v : options) {
            tmp.put(v.name, v);
        }
        this.options = ImmutableMap.copyOf(tmp);
        this.systemOptions = systemOptions;
    }

    @Override
    public Iterator<OptionValue> iterator() {
        return Iterables.concat(this.systemOptions, this.options.values()).iterator();
    }

    @Override
    public OptionValue getOption(String name) {
        OptionValue value = this.options.get(name);
        if (value == null && this.systemOptions != null) {
            value = this.systemOptions.getOption(name);
        }
        return value;
    }

    @Override
    public void setOption(OptionValue value) throws SetOptionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOption(String name, SqlLiteral literal, OptionValue.OptionType type) throws SetOptionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OptionManager.OptionAdmin getAdmin() {
        throw new UnsupportedOperationException();
    }

    @Override
    public OptionList getOptionList() {
        throw new UnsupportedOperationException();
    }
}

