/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import java.io.Closeable;
import java.io.IOException;
import org.apache.drill.exec.cache.DistributedCache;
import org.apache.drill.exec.cache.local.LocalCache;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.local.LocalClusterCoordinator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteServiceSet
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(RemoteServiceSet.class);
    private final DistributedCache cache;
    private final ClusterCoordinator coordinator;

    public RemoteServiceSet(DistributedCache cache, ClusterCoordinator coordinator) {
        this.cache = cache;
        this.coordinator = coordinator;
    }

    public DistributedCache getCache() {
        return this.cache;
    }

    public ClusterCoordinator getCoordinator() {
        return this.coordinator;
    }

    @Override
    public void close() throws IOException {
        try {
            this.cache.close();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException("Failure while closing cache", e);
        }
        this.coordinator.close();
    }

    public static RemoteServiceSet getLocalServiceSet() {
        return new RemoteServiceSet(new LocalCache(), new LocalClusterCoordinator());
    }
}

