/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.cache.DistributedCache;
import org.apache.drill.exec.compile.CodeCompiler;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.physical.impl.OperatorCreatorRegistry;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.control.Controller;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.data.DataConnectionCreator;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.server.options.SystemOptionManager;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillbitContext {
    static final Logger logger = LoggerFactory.getLogger(DrillbitContext.class);
    private final BootStrapContext context;
    private PhysicalPlanReader reader;
    private final ClusterCoordinator coord;
    private final DataConnectionCreator connectionsPool;
    private final DistributedCache cache;
    private final CoordinationProtos.DrillbitEndpoint endpoint;
    private final StoragePluginRegistry storagePlugins;
    private final OperatorCreatorRegistry operatorCreatorRegistry;
    private final Controller controller;
    private final WorkEventBus workBus;
    private final FunctionImplementationRegistry functionRegistry;
    private final SystemOptionManager systemOptions;
    private final PStoreProvider provider;
    private final CodeCompiler compiler;

    public DrillbitContext(CoordinationProtos.DrillbitEndpoint endpoint, BootStrapContext context, ClusterCoordinator coord, Controller controller, DataConnectionCreator connectionsPool, DistributedCache cache, WorkEventBus workBus, PStoreProvider provider) {
        Preconditions.checkNotNull(endpoint);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(controller);
        Preconditions.checkNotNull(connectionsPool);
        this.workBus = workBus;
        this.controller = controller;
        this.context = context;
        this.coord = coord;
        this.connectionsPool = connectionsPool;
        this.cache = cache;
        this.endpoint = endpoint;
        this.provider = provider;
        this.storagePlugins = new StoragePluginRegistry(this);
        this.reader = new PhysicalPlanReader(context.getConfig(), context.getConfig().getMapper(), endpoint, this.storagePlugins);
        this.operatorCreatorRegistry = new OperatorCreatorRegistry(context.getConfig());
        this.functionRegistry = new FunctionImplementationRegistry(context.getConfig());
        this.systemOptions = new SystemOptionManager(context.getConfig(), provider);
        this.compiler = new CodeCompiler(context.getConfig(), cache, this.systemOptions);
    }

    public FunctionImplementationRegistry getFunctionImplementationRegistry() {
        return this.functionRegistry;
    }

    public WorkEventBus getWorkBus() {
        return this.workBus;
    }

    public SystemOptionManager getOptionManager() {
        return this.systemOptions;
    }

    public CoordinationProtos.DrillbitEndpoint getEndpoint() {
        return this.endpoint;
    }

    public DrillConfig getConfig() {
        return this.context.getConfig();
    }

    public Collection<CoordinationProtos.DrillbitEndpoint> getBits() {
        return this.coord.getAvailableEndpoints();
    }

    public BufferAllocator getAllocator() {
        return this.context.getAllocator();
    }

    public OperatorCreatorRegistry getOperatorCreatorRegistry() {
        return this.operatorCreatorRegistry;
    }

    public StoragePluginRegistry getStorage() {
        return this.storagePlugins;
    }

    public DataConnectionCreator getDataConnectionsPool() {
        return this.connectionsPool;
    }

    public Controller getController() {
        return this.controller;
    }

    public MetricRegistry getMetrics() {
        return this.context.getMetrics();
    }

    public DistributedCache getCache() {
        return this.cache;
    }

    public PhysicalPlanReader getPlanReader() {
        return this.reader;
    }

    public PStoreProvider getPersistentStoreProvider() {
        return this.provider;
    }

    public StoragePluginRegistry.DrillSchemaFactory getSchemaFactory() {
        return this.storagePlugins.getSchemaFactory();
    }

    public ClusterCoordinator getClusterCoordinator() {
        return this.coord;
    }

    public CodeCompiler getCompiler() {
        return this.compiler;
    }
}

