/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.server;

import com.codahale.metrics.servlets.MetricsServlet;
import com.codahale.metrics.servlets.ThreadDumpServlet;
import com.google.common.io.Closeables;
import java.io.Closeable;
import javax.servlet.Servlet;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.exec.cache.DistributedCache;
import org.apache.drill.exec.cache.infinispan.ICache;
import org.apache.drill.exec.coord.ClusterCoordinator;
import org.apache.drill.exec.coord.zk.ZKClusterCoordinator;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.server.RemoteServiceSet;
import org.apache.drill.exec.server.rest.DrillRestServer;
import org.apache.drill.exec.service.ServiceEngine;
import org.apache.drill.exec.store.sys.PStoreProvider;
import org.apache.drill.exec.store.sys.PStoreRegistry;
import org.apache.drill.exec.store.sys.local.LocalPStoreProvider;
import org.apache.drill.exec.work.WorkManager;
import org.apache.zookeeper.Environment;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Drillbit
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(Drillbit.class);
    final ClusterCoordinator coord;
    final ServiceEngine engine;
    final DistributedCache cache;
    final PStoreProvider storeProvider;
    final WorkManager manager;
    final BootStrapContext context;
    final Server embeddedJetty;
    private volatile ClusterCoordinator.RegistrationHandle handle;

    public Drillbit(DrillConfig config, RemoteServiceSet serviceSet) throws Exception {
        boolean allowPortHunting = serviceSet != null;
        boolean enableHttp = config.getBoolean("drill.exec.http.enabled");
        this.context = new BootStrapContext(config);
        this.manager = new WorkManager(this.context);
        this.engine = new ServiceEngine(this.manager.getControlMessageHandler(), this.manager.getUserWorker(), this.context, this.manager.getWorkBus(), this.manager.getDataHandler(), allowPortHunting);
        this.embeddedJetty = enableHttp ? new Server(config.getInt("drill.exec.http.port")) : null;
        if (serviceSet != null) {
            this.coord = serviceSet.getCoordinator();
            this.cache = serviceSet.getCache();
            this.storeProvider = new LocalPStoreProvider(config);
        } else {
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(config));
            this.coord = new ZKClusterCoordinator(config);
            this.storeProvider = new PStoreRegistry(this.coord, config).newPStoreProvider();
            this.cache = new ICache(config, this.context.getAllocator(), false);
        }
    }

    private void startJetty() throws Exception {
        if (this.embeddedJetty == null) {
            return;
        }
        ServletContextHandler context = new ServletContextHandler(0);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setShowMessageInTitle(true);
        context.setErrorHandler(errorHandler);
        context.setContextPath("/");
        this.embeddedJetty.setHandler((Handler)context);
        ServletHolder h = new ServletHolder((Servlet)new ServletContainer((ResourceConfig)new DrillRestServer(this.manager)));
        h.setInitOrder(1);
        context.addServlet(h, "/*");
        context.addServlet(new ServletHolder((Servlet)new MetricsServlet(this.context.getMetrics())), "/status/metrics");
        context.addServlet(new ServletHolder((Servlet)new ThreadDumpServlet()), "/status/threads");
        this.embeddedJetty.start();
        System.out.println("");
    }

    public void run() throws Exception {
        this.coord.start(10000L);
        this.storeProvider.start();
        CoordinationProtos.DrillbitEndpoint md = this.engine.start();
        this.manager.start(md, this.cache, this.engine.getController(), this.engine.getDataConnectionCreator(), this.coord, this.storeProvider);
        this.cache.run();
        this.manager.getContext().getStorage().init();
        this.manager.getContext().getOptionManager().init();
        this.handle = this.coord.register(md);
        this.startJetty();
    }

    @Override
    public void close() {
        if (this.coord != null && this.handle != null) {
            this.coord.unregister(this.handle);
        }
        try {
            Thread.sleep(this.context.getConfig().getInt("drill.exec.zk.refresh") * 2);
        }
        catch (InterruptedException e) {
            logger.warn("Interrupted while sleeping during coordination deregistration.");
        }
        try {
            if (this.embeddedJetty != null) {
                this.embeddedJetty.stop();
            }
        }
        catch (Exception e) {
            logger.warn("Failure while shutting down embedded jetty server.");
        }
        try {
            this.cache.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Closeables.closeQuietly(this.engine);
        Closeables.closeQuietly(this.storeProvider);
        Closeables.closeQuietly(this.coord);
        Closeables.closeQuietly(this.manager);
        Closeables.closeQuietly(this.context);
        logger.info("Shutdown completed.");
    }

    static {
        Environment.logEnv("Drillbit environment:.", logger);
    }

    private class ShutdownThread
    extends Thread {
        ShutdownThread(DrillConfig config) {
            this.setName("ShutdownHook");
        }

        @Override
        public void run() {
            logger.info("Received shutdown request.");
            Drillbit.this.close();
        }
    }
}

