/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import com.google.common.collect.Maps;
import java.util.Map;
import net.hydromatic.optiq.SchemaPlus;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.SessionOptionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSession {
    static final Logger logger = LoggerFactory.getLogger(UserSession.class);
    private boolean enableExchanges = true;
    private boolean supportComplexTypes = false;
    private UserBitShared.UserCredentials credentials;
    private Map<String, String> properties;
    private OptionManager sessionOptions;

    private UserSession() {
    }

    public boolean isSupportComplexTypes() {
        return this.supportComplexTypes;
    }

    public OptionManager getOptions() {
        return this.sessionOptions;
    }

    public boolean setDefaultSchemaPath(String fullPath, SchemaPlus schema) {
        SchemaPlus newDefault = this.findSchema(schema, fullPath);
        if (newDefault == null) {
            return false;
        }
        this.setProp("schema", fullPath);
        return true;
    }

    public SchemaPlus getDefaultSchema(SchemaPlus rootSchema) {
        return this.findSchema(rootSchema, this.getProp("schema"));
    }

    private String getProp(String key) {
        return this.properties.get(key) != null ? this.properties.get(key) : "";
    }

    private void setProp(String key, String value) {
        this.properties.put(key, value);
    }

    private SchemaPlus findSchema(SchemaPlus rootSchema, String schemaPath) {
        String p;
        String[] paths = schemaPath.split("\\.");
        SchemaPlus schema = rootSchema;
        String[] arr$ = paths;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (schema = schema.getSubSchema(p = arr$[i$])) != null; ++i$) {
        }
        return schema;
    }

    public static class Builder {
        UserSession userSession = new UserSession();

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withCredentials(UserBitShared.UserCredentials credentials) {
            this.userSession.credentials = credentials;
            return this;
        }

        public Builder withOptionManager(OptionManager systemOptions) {
            this.userSession.sessionOptions = new SessionOptionManager(systemOptions);
            return this;
        }

        public Builder withUserProperties(UserProtos.UserProperties properties) {
            this.userSession.properties = Maps.newHashMap();
            if (properties != null) {
                for (int i = 0; i < properties.getPropertiesCount(); ++i) {
                    UserProtos.Property prop = properties.getProperties(i);
                    this.userSession.properties.put(prop.getKey(), prop.getValue());
                }
            }
            return this;
        }

        public Builder setSupportComplexTypes(boolean supportComplexTypes) {
            this.userSession.supportComplexTypes = supportComplexTypes;
            return this;
        }

        public UserSession build() {
            UserSession session = this.userSession;
            this.userSession = null;
            return session;
        }

        Builder() {
        }
    }
}

