/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.EventLoopGroup;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserProtos;
import org.apache.drill.exec.rpc.BasicClientWithConnection;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryResultHandler;
import org.apache.drill.exec.rpc.user.UserProtobufLengthDecoder;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.apache.drill.exec.rpc.user.UserRpcConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserClient
extends BasicClientWithConnection<UserProtos.RpcType, UserProtos.UserToBitHandshake, UserProtos.BitToUserHandshake> {
    static final Logger logger = LoggerFactory.getLogger(UserClient.class);
    private final QueryResultHandler queryResultHandler = new QueryResultHandler();
    private boolean supportComplexTypes = true;

    public UserClient(boolean supportComplexTypes, BufferAllocator alloc, EventLoopGroup eventLoopGroup) {
        super(UserRpcConfig.MAPPING, alloc, eventLoopGroup, UserProtos.RpcType.HANDSHAKE, UserProtos.BitToUserHandshake.class, UserProtos.BitToUserHandshake.PARSER);
        this.supportComplexTypes = supportComplexTypes;
    }

    public void submitQuery(UserResultsListener resultsListener, UserProtos.RunQuery query) {
        this.send(this.queryResultHandler.getWrappedListener(resultsListener), UserProtos.RpcType.RUN_QUERY, query, UserBitShared.QueryId.class, new ByteBuf[0]);
    }

    public void connect(RpcConnectionHandler<BasicClientWithConnection.ServerConnection> handler, CoordinationProtos.DrillbitEndpoint endpoint, UserProtos.UserProperties props) throws RpcException, InterruptedException {
        UserProtos.UserToBitHandshake.Builder hsBuilder = UserProtos.UserToBitHandshake.newBuilder().setRpcVersion(UserRpcConfig.RPC_VERSION).setSupportListening(true).setSupportComplexTypes(this.supportComplexTypes);
        if (props != null) {
            hsBuilder.setProperties(props);
        }
        this.connectAsClient(handler, hsBuilder.build(), endpoint.getAddress(), endpoint.getUserPort());
    }

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        switch (rpcType) {
            case 1: {
                return GeneralRPCProtos.Ack.getDefaultInstance();
            }
            case 0: {
                return UserProtos.BitToUserHandshake.getDefaultInstance();
            }
            case 7: {
                return UserBitShared.QueryId.getDefaultInstance();
            }
            case 6: {
                return UserBitShared.QueryResult.getDefaultInstance();
            }
        }
        throw new RpcException(String.format("Unable to deal with RpcType of %d", rpcType));
    }

    @Override
    protected Response handleReponse(ConnectionThrottle throttle, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        switch (rpcType) {
            case 6: {
                this.queryResultHandler.batchArrived(throttle, pBody, dBody);
                return new Response(UserProtos.RpcType.ACK, GeneralRPCProtos.Ack.getDefaultInstance(), new ByteBuf[0]);
            }
        }
        throw new RpcException(String.format("Unknown Rpc Type %d. ", rpcType));
    }

    @Override
    protected void validateHandshake(UserProtos.BitToUserHandshake inbound) throws RpcException {
        if (inbound.getRpcVersion() != UserRpcConfig.RPC_VERSION) {
            throw new RpcException(String.format("Invalid rpc version.  Expected %d, actual %d.", inbound.getRpcVersion(), UserRpcConfig.RPC_VERSION));
        }
    }

    @Override
    protected void finalizeConnection(UserProtos.BitToUserHandshake handshake, BasicClientWithConnection.ServerConnection connection) {
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator) {
        return new UserProtobufLengthDecoder(allocator, OutOfMemoryHandler.DEFAULT_INSTANCE);
    }
}

