/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.user;

import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import org.apache.drill.exec.rpc.RpcBus;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.user.ConnectionThrottle;
import org.apache.drill.exec.rpc.user.QueryResultBatch;
import org.apache.drill.exec.rpc.user.UserResultsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResultHandler {
    static final Logger logger = LoggerFactory.getLogger(QueryResultHandler.class);
    private ConcurrentMap<UserBitShared.QueryId, UserResultsListener> resultsListener = Maps.newConcurrentMap();

    public RpcOutcomeListener<UserBitShared.QueryId> getWrappedListener(UserResultsListener listener) {
        return new SubmissionListener(listener);
    }

    public void batchArrived(ConnectionThrottle throttle, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        boolean failed;
        UserBitShared.QueryResult result = RpcBus.get(pBody, UserBitShared.QueryResult.PARSER);
        QueryResultBatch batch = new QueryResultBatch(result, (DrillBuf)dBody);
        boolean bl = failed = batch.getHeader().getQueryState() == UserBitShared.QueryResult.QueryState.FAILED;
        assert (failed || batch.getHeader().getErrorCount() == 0) : "Error count for the query batch is non-zero but QueryState != FAILED";
        UserResultsListener l = (UserResultsListener)this.resultsListener.get(result.getQueryId());
        if (l == null) {
            BufferingListener bl2 = new BufferingListener();
            l = this.resultsListener.putIfAbsent(result.getQueryId(), bl2);
            if (l == null) {
                l = bl2;
            }
            if (result.getQueryId().toString().equals("")) {
                this.failAll();
            }
        }
        if (failed) {
            String message = this.buildErrorMessage(batch);
            l.submissionFailed(new RpcException(message));
            this.resultsListener.remove(result.getQueryId(), l);
        } else {
            try {
                l.resultArrived(batch, throttle);
            }
            catch (Exception e) {
                batch.release();
                l.submissionFailed(new RpcException(e));
            }
        }
        if (!(!failed && !result.getIsLastChunk() || l instanceof BufferingListener && ((BufferingListener)l).output == null)) {
            this.resultsListener.remove(result.getQueryId(), l);
        }
    }

    protected String buildErrorMessage(QueryResultBatch batch) {
        StringBuilder sb = new StringBuilder();
        for (UserBitShared.DrillPBError error : batch.getHeader().getErrorList()) {
            sb.append(error.getMessage());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void failAll() {
        for (UserResultsListener l : this.resultsListener.values()) {
            l.submissionFailed(new RpcException("Received result without QueryId"));
        }
    }

    private class SubmissionListener
    extends BaseRpcOutcomeListener<UserBitShared.QueryId> {
        private UserResultsListener listener;

        public SubmissionListener(UserResultsListener listener) {
            this.listener = listener;
        }

        @Override
        public void failed(RpcException ex) {
            this.listener.submissionFailed(ex);
        }

        @Override
        public void success(UserBitShared.QueryId queryId, ByteBuf buf) {
            this.listener.queryIdArrived(queryId);
            logger.debug("Received QueryId {} succesfully.  Adding listener {}", (Object)queryId, (Object)this.listener);
            UserResultsListener oldListener = QueryResultHandler.this.resultsListener.putIfAbsent(queryId, this.listener);
            if (oldListener != null) {
                logger.debug("Unable to place user results listener, buffering listener was already in place.");
                if (oldListener instanceof BufferingListener) {
                    QueryResultHandler.this.resultsListener.remove(oldListener);
                    boolean all = ((BufferingListener)oldListener).transferTo(this.listener);
                    if (all) {
                        QueryResultHandler.this.resultsListener.remove(oldListener);
                    } else {
                        boolean replaced = QueryResultHandler.this.resultsListener.replace(queryId, oldListener, this.listener);
                        if (!replaced) {
                            throw new IllegalStateException();
                        }
                    }
                } else {
                    throw new IllegalStateException("Trying to replace a non-buffering User Results listener.");
                }
            }
        }
    }

    private class BufferingListener
    implements UserResultsListener {
        private ConcurrentLinkedQueue<QueryResultBatch> results = Queues.newConcurrentLinkedQueue();
        private volatile boolean finished = false;
        private volatile RpcException ex;
        private volatile UserResultsListener output;
        private volatile ConnectionThrottle throttle;

        private BufferingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean transferTo(UserResultsListener l) {
            BufferingListener bufferingListener = this;
            synchronized (bufferingListener) {
                this.output = l;
                boolean last = false;
                for (QueryResultBatch r : this.results) {
                    l.resultArrived(r, this.throttle);
                    last = r.getHeader().getIsLastChunk();
                }
                if (this.ex != null) {
                    l.submissionFailed(this.ex);
                    return true;
                }
                return last;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resultArrived(QueryResultBatch result, ConnectionThrottle throttle) {
            this.throttle = throttle;
            if (result.getHeader().getIsLastChunk()) {
                this.finished = true;
            }
            BufferingListener bufferingListener = this;
            synchronized (bufferingListener) {
                if (this.output == null) {
                    this.results.add(result);
                } else {
                    this.output.resultArrived(result, throttle);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void submissionFailed(RpcException ex) {
            this.finished = true;
            BufferingListener bufferingListener = this;
            synchronized (bufferingListener) {
                if (this.output == null) {
                    this.ex = ex;
                } else {
                    this.output.submissionFailed(ex);
                }
            }
        }

        @Override
        public void queryIdArrived(UserBitShared.QueryId queryId) {
        }
    }
}

