/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.Semaphore;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.record.FragmentWritableBatch;
import org.apache.drill.exec.rpc.ListeningCommand;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.data.DataClientConnection;
import org.apache.drill.exec.rpc.data.DataConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTunnel {
    static final Logger logger = LoggerFactory.getLogger(DataTunnel.class);
    private final DataConnectionManager manager;
    private final Semaphore sendingSemaphore = new Semaphore(3);

    public DataTunnel(DataConnectionManager manager) {
        this.manager = manager;
    }

    public void sendRecordBatch(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, FragmentWritableBatch batch) {
        SendBatchAsyncListen b = new SendBatchAsyncListen(outcomeListener, batch);
        try {
            this.sendingSemaphore.acquire();
            this.manager.runCommand(b);
        }
        catch (InterruptedException e) {
            outcomeListener.failed(new RpcException("Interrupted while trying to get sending semaphore.", e));
        }
    }

    private class SendBatchAsyncListen
    extends ListeningCommand<GeneralRPCProtos.Ack, DataClientConnection> {
        final FragmentWritableBatch batch;

        public SendBatchAsyncListen(RpcOutcomeListener<GeneralRPCProtos.Ack> listener, FragmentWritableBatch batch) {
            super(listener);
            this.batch = batch;
        }

        @Override
        public void doRpcCall(RpcOutcomeListener<GeneralRPCProtos.Ack> outcomeListener, DataClientConnection connection) {
            connection.send(new ThrottlingOutcomeListener(outcomeListener), BitData.RpcType.REQ_RECORD_BATCH, this.batch.getHeader(), GeneralRPCProtos.Ack.class, this.batch.getBuffers());
        }

        public String toString() {
            return "SendBatch [batch.header=" + this.batch.getHeader() + "]";
        }

        @Override
        public void connectionFailed(RpcConnectionHandler.FailureType type, Throwable t) {
            for (ByteBuf buffer : this.batch.getBuffers()) {
                buffer.release();
            }
            super.connectionFailed(type, t);
        }
    }

    private class ThrottlingOutcomeListener
    implements RpcOutcomeListener<GeneralRPCProtos.Ack> {
        RpcOutcomeListener<GeneralRPCProtos.Ack> inner;

        public ThrottlingOutcomeListener(RpcOutcomeListener<GeneralRPCProtos.Ack> inner) {
            this.inner = inner;
        }

        @Override
        public void failed(RpcException ex) {
            DataTunnel.this.sendingSemaphore.release();
            this.inner.failed(ex);
        }

        @Override
        public void success(GeneralRPCProtos.Ack value, ByteBuf buffer) {
            DataTunnel.this.sendingSemaphore.release();
            this.inner.success(value, buffer);
        }
    }
}

