/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.record.RawFragmentBatch;
import org.apache.drill.exec.rpc.Acks;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.data.DataResponseHandler;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataResponseHandlerImpl
implements DataResponseHandler {
    static final Logger logger = LoggerFactory.getLogger(DataResponseHandlerImpl.class);
    private final WorkManager.WorkerBee bee;

    public DataResponseHandlerImpl(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    @Override
    public void informOutOfMemory() {
        logger.error("Out of memory outside any particular fragment.");
    }

    @Override
    public void handle(RemoteConnection connection, FragmentManager manager, BitData.FragmentRecordBatch fragmentBatch, DrillBuf data, ResponseSender sender) throws RpcException {
        try {
            boolean canRun = manager.handle(new RawFragmentBatch(connection, fragmentBatch, data, sender));
            if (canRun) {
                this.bee.startFragmentPendingRemote(manager);
            }
            if (fragmentBatch.getIsLastBatch() && !manager.isWaiting()) {
                this.bee.getContext().getWorkBus().removeFragmentManager(manager.getHandle());
            }
        }
        catch (FragmentSetupException e) {
            logger.error("Failure while attempting to setup new fragment.", e);
            sender.send(new Response(BitData.RpcType.ACK, Acks.FAIL, new ByteBuf[0]));
        }
    }
}

