/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.rpc.control.WorkEventBus;
import org.apache.drill.exec.rpc.data.DataConnectionManager;
import org.apache.drill.exec.rpc.data.DataResponseHandler;
import org.apache.drill.exec.rpc.data.DataServer;
import org.apache.drill.exec.rpc.data.DataTunnel;
import org.apache.drill.exec.server.BootStrapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataConnectionCreator
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(DataConnectionCreator.class);
    private volatile DataServer server;
    private final BootStrapContext context;
    private final WorkEventBus workBus;
    private final DataResponseHandler dataHandler;
    private final boolean allowPortHunting;
    private ConcurrentMap<CoordinationProtos.DrillbitEndpoint, DataConnectionManager> connectionManager = Maps.newConcurrentMap();

    public DataConnectionCreator(BootStrapContext context, WorkEventBus workBus, DataResponseHandler dataHandler, boolean allowPortHunting) {
        this.context = context;
        this.workBus = workBus;
        this.dataHandler = dataHandler;
        this.allowPortHunting = allowPortHunting;
    }

    public CoordinationProtos.DrillbitEndpoint start(CoordinationProtos.DrillbitEndpoint partialEndpoint) throws InterruptedException, DrillbitStartupException {
        this.server = new DataServer(this.context, this.workBus, this.dataHandler);
        int port = this.server.bind(partialEndpoint.getControlPort() + 1, this.allowPortHunting);
        CoordinationProtos.DrillbitEndpoint completeEndpoint = partialEndpoint.toBuilder().setDataPort(port).build();
        return completeEndpoint;
    }

    public DataTunnel getTunnel(CoordinationProtos.DrillbitEndpoint endpoint, ExecProtos.FragmentHandle handle) {
        DataConnectionManager newManager = new DataConnectionManager(handle, endpoint, this.context);
        DataConnectionManager oldManager = this.connectionManager.putIfAbsent(endpoint, newManager);
        if (oldManager != null) {
            newManager = oldManager;
        }
        return new DataTunnel(newManager);
    }

    @Override
    public void close() {
        Closeables.closeQuietly(this.server);
    }
}

