/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.data;

import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.ReconnectingConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.data.DataClientConnection;
import org.apache.drill.exec.rpc.data.DataDefaultInstanceHandler;
import org.apache.drill.exec.rpc.data.DataProtobufLengthDecoder;
import org.apache.drill.exec.rpc.data.DataRpcConfig;
import org.apache.drill.exec.server.BootStrapContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataClient
extends BasicClient<BitData.RpcType, DataClientConnection, BitData.BitClientHandshake, BitData.BitServerHandshake> {
    static final Logger logger = LoggerFactory.getLogger(DataClient.class);
    private final CoordinationProtos.DrillbitEndpoint remoteEndpoint;
    private volatile DataClientConnection connection;
    private final BufferAllocator allocator;
    private final ReconnectingConnection.CloseHandlerCreator closeHandlerFactory;

    public DataClient(CoordinationProtos.DrillbitEndpoint remoteEndpoint, BootStrapContext context, ReconnectingConnection.CloseHandlerCreator closeHandlerFactory) {
        super(DataRpcConfig.MAPPING, context.getAllocator().getUnderlyingAllocator(), context.getBitClientLoopGroup(), BitData.RpcType.HANDSHAKE, BitData.BitServerHandshake.class, BitData.BitServerHandshake.PARSER);
        this.remoteEndpoint = remoteEndpoint;
        this.closeHandlerFactory = closeHandlerFactory;
        this.allocator = context.getAllocator();
    }

    @Override
    public DataClientConnection initRemoteConnection(Channel channel) {
        this.connection = new DataClientConnection(channel, this);
        return this.connection;
    }

    @Override
    protected GenericFutureListener<ChannelFuture> getCloseHandler(DataClientConnection clientConnection) {
        return this.closeHandlerFactory.getHandler(clientConnection, super.getCloseHandler(clientConnection));
    }

    @Override
    public MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return DataDefaultInstanceHandler.getResponseDefaultInstanceClient(rpcType);
    }

    @Override
    protected Response handle(DataClientConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        throw new UnsupportedOperationException("DataClient is unidirectional by design.");
    }

    BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    protected void validateHandshake(BitData.BitServerHandshake handshake) throws RpcException {
        if (handshake.getRpcVersion() != DataRpcConfig.RPC_VERSION) {
            throw new RpcException(String.format("Invalid rpc version.  Expected %d, actual %d.", handshake.getRpcVersion(), DataRpcConfig.RPC_VERSION));
        }
    }

    @Override
    protected void finalizeConnection(BitData.BitServerHandshake handshake, DataClientConnection connection) {
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator) {
        return new DataProtobufLengthDecoder(allocator, OutOfMemoryHandler.DEFAULT_INSTANCE);
    }
}

