/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.drill.exec.cache.DistributedMap;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.work.WorkManager;
import org.apache.drill.exec.work.foreman.Foreman;
import org.apache.drill.exec.work.foreman.FragmentStatusListener;
import org.apache.drill.exec.work.fragment.FragmentManager;
import org.apache.drill.exec.work.fragment.NonRootFragmentManager;
import org.apache.drill.exec.work.fragment.RootFragmentManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkEventBus {
    static final Logger logger = LoggerFactory.getLogger(WorkEventBus.class);
    private final ConcurrentMap<ExecProtos.FragmentHandle, FragmentManager> managers = Maps.newConcurrentMap();
    private final ConcurrentMap<UserBitShared.QueryId, FragmentStatusListener> listeners = new ConcurrentHashMap<UserBitShared.QueryId, FragmentStatusListener>(16, 0.75f, 16);
    private final WorkManager.WorkerBee bee;
    private final Cache<ExecProtos.FragmentHandle, Void> cancelledFragments = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(10L, TimeUnit.MINUTES).build();

    public WorkEventBus(WorkManager.WorkerBee bee) {
        this.bee = bee;
    }

    public void removeFragmentStatusListener(UserBitShared.QueryId queryId) {
        logger.debug("Removing framgent status listener for queryId {}.", (Object)queryId);
        this.listeners.remove(queryId);
    }

    public void setFragmentStatusListener(UserBitShared.QueryId queryId, FragmentStatusListener listener) throws RpcException {
        logger.debug("Adding fragment status listener for queryId {}.", (Object)queryId);
        FragmentStatusListener old = this.listeners.putIfAbsent(queryId, listener);
        if (old != null) {
            throw new RpcException("Failure.  The provided handle already exists in the listener pool.  You need to remove one listener before adding another.");
        }
    }

    public void status(BitControl.FragmentStatus status) {
        FragmentStatusListener l = (FragmentStatusListener)this.listeners.get(status.getHandle().getQueryId());
        if (l == null) {
            logger.error("A fragment message arrived but there was no registered listener for that message for handle {}.", (Object)status.getHandle());
            return;
        }
        l.statusUpdate(status);
    }

    public void setRootFragmentManager(RootFragmentManager fragmentManager) {
        FragmentManager old = this.managers.putIfAbsent(fragmentManager.getHandle(), fragmentManager);
        if (old != null) {
            throw new IllegalStateException("Tried to set fragment manager when has already been set for the provided fragment handle.");
        }
    }

    public FragmentManager getFragmentManager(ExecProtos.FragmentHandle handle) {
        return (FragmentManager)this.managers.get(handle);
    }

    public FragmentManager getOrCreateFragmentManager(ExecProtos.FragmentHandle handle) throws FragmentSetupException {
        if (this.cancelledFragments.asMap().containsKey(handle)) {
            logger.debug("Fragment: {} was cancelled. Ignoring fragment handle", (Object)handle);
            return null;
        }
        FragmentManager manager = (FragmentManager)this.managers.get(handle);
        if (manager != null) {
            return manager;
        }
        DistributedMap<ExecProtos.FragmentHandle, BitControl.PlanFragment> planCache = this.bee.getContext().getCache().getMap(Foreman.FRAGMENT_CACHE);
        for (Map.Entry<ExecProtos.FragmentHandle, BitControl.PlanFragment> entry : planCache.getLocalEntries()) {
        }
        BitControl.PlanFragment fragment = this.bee.getContext().getCache().getMap(Foreman.FRAGMENT_CACHE).get(handle);
        if (fragment == null) {
            throw new FragmentSetupException("Received batch where fragment was not in cache.");
        }
        NonRootFragmentManager newManager = new NonRootFragmentManager(fragment, this.bee);
        manager = this.managers.putIfAbsent(fragment.getHandle(), newManager);
        if (manager == null) {
            this.bee.addFragmentPendingRemote(newManager);
            manager = newManager;
        }
        return manager;
    }

    public void removeFragmentManager(ExecProtos.FragmentHandle handle) {
        this.managers.remove(handle);
    }
}

