/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.rpc.BasicServer;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.control.ConnectionManagerRegistry;
import org.apache.drill.exec.rpc.control.ControlConnection;
import org.apache.drill.exec.rpc.control.ControlConnectionManager;
import org.apache.drill.exec.rpc.control.ControlProtobufLengthDecoder;
import org.apache.drill.exec.rpc.control.ControlRpcConfig;
import org.apache.drill.exec.rpc.control.DefaultInstanceHandler;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.work.batch.ControlMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlServer
extends BasicServer<BitControl.RpcType, ControlConnection> {
    static final Logger logger = LoggerFactory.getLogger(ControlServer.class);
    private final ControlMessageHandler handler;
    private final ConnectionManagerRegistry connectionRegistry;
    private volatile ProxyCloseHandler proxyCloseHandler;
    private BufferAllocator allocator;

    public ControlServer(ControlMessageHandler handler, BootStrapContext context, ConnectionManagerRegistry connectionRegistry) {
        super(ControlRpcConfig.MAPPING, context.getAllocator().getUnderlyingAllocator(), context.getBitLoopGroup());
        this.handler = handler;
        this.connectionRegistry = connectionRegistry;
        this.allocator = context.getAllocator();
    }

    @Override
    public MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return DefaultInstanceHandler.getResponseDefaultInstance(rpcType);
    }

    @Override
    protected Response handle(ControlConnection connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        return this.handler.handle(connection, rpcType, pBody, dBody);
    }

    @Override
    protected GenericFutureListener<ChannelFuture> getCloseHandler(ControlConnection connection) {
        this.proxyCloseHandler = new ProxyCloseHandler(super.getCloseHandler(connection));
        return this.proxyCloseHandler;
    }

    @Override
    public ControlConnection initRemoteConnection(Channel channel) {
        return new ControlConnection(channel, this, this.allocator);
    }

    @Override
    protected BasicServer.ServerHandshakeHandler<BitControl.BitControlHandshake> getHandshakeHandler(final ControlConnection connection) {
        return new BasicServer.ServerHandshakeHandler<BitControl.BitControlHandshake>((Internal.EnumLite)BitControl.RpcType.HANDSHAKE, BitControl.BitControlHandshake.PARSER){

            @Override
            public MessageLite getHandshakeResponse(BitControl.BitControlHandshake inbound) throws Exception {
                if (inbound.getRpcVersion() != ControlRpcConfig.RPC_VERSION) {
                    throw new RpcException(String.format("Invalid rpc version.  Expected %d, actual %d.", inbound.getRpcVersion(), ControlRpcConfig.RPC_VERSION));
                }
                if (!inbound.hasEndpoint() || inbound.getEndpoint().getAddress().isEmpty() || inbound.getEndpoint().getControlPort() < 1) {
                    throw new RpcException(String.format("RPC didn't provide valid counter endpoint information.  Received %s.", inbound.getEndpoint()));
                }
                connection.setEndpoint(inbound.getEndpoint());
                ControlConnectionManager manager = ControlServer.this.connectionRegistry.getConnectionManager(inbound.getEndpoint());
                ControlServer.this.proxyCloseHandler.setHandler(manager.getCloseHandlerCreator().getHandler(connection, ControlServer.this.proxyCloseHandler.getHandler()));
                manager.addExternalConnection(connection);
                return BitControl.BitControlHandshake.newBuilder().setRpcVersion(ControlRpcConfig.RPC_VERSION).build();
            }
        };
    }

    @Override
    public ProtobufLengthDecoder getDecoder(BufferAllocator allocator, OutOfMemoryHandler outOfMemoryHandler) {
        return new ControlProtobufLengthDecoder(allocator, outOfMemoryHandler);
    }

    private class ProxyCloseHandler
    implements GenericFutureListener<ChannelFuture> {
        private volatile GenericFutureListener<ChannelFuture> handler;

        public ProxyCloseHandler(GenericFutureListener<ChannelFuture> handler) {
            this.handler = handler;
        }

        public GenericFutureListener<ChannelFuture> getHandler() {
            return this.handler;
        }

        public void setHandler(GenericFutureListener<ChannelFuture> handler) {
            this.handler = handler;
        }

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            this.handler.operationComplete(future);
        }
    }
}

