/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc.control;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.rpc.control.ControlConnectionManager;
import org.apache.drill.exec.server.BootStrapContext;
import org.apache.drill.exec.work.batch.ControlMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerRegistry
implements Iterable<ControlConnectionManager> {
    static final Logger logger = LoggerFactory.getLogger(ConnectionManagerRegistry.class);
    private final ConcurrentMap<CoordinationProtos.DrillbitEndpoint, ControlConnectionManager> registry = Maps.newConcurrentMap();
    private final ControlMessageHandler handler;
    private final BootStrapContext context;
    private volatile CoordinationProtos.DrillbitEndpoint localEndpoint;

    public ConnectionManagerRegistry(ControlMessageHandler handler, BootStrapContext context) {
        this.handler = handler;
        this.context = context;
    }

    public ControlConnectionManager getConnectionManager(CoordinationProtos.DrillbitEndpoint endpoint) {
        ControlConnectionManager m2;
        assert (this.localEndpoint != null) : "DrillbitEndpoint must be set before a connection manager can be retrieved";
        ControlConnectionManager m = (ControlConnectionManager)this.registry.get(endpoint);
        if (m == null && (m2 = this.registry.putIfAbsent(endpoint, m = new ControlConnectionManager(endpoint, this.localEndpoint, this.handler, this.context))) != null) {
            m = m2;
        }
        return m;
    }

    @Override
    public Iterator<ControlConnectionManager> iterator() {
        return this.registry.values().iterator();
    }

    public void setEndpoint(CoordinationProtos.DrillbitEndpoint endpoint) {
        this.localEndpoint = endpoint;
    }
}

