/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import java.util.concurrent.ExecutionException;
import org.apache.drill.common.exceptions.DrillIOException;
import org.apache.drill.common.util.DrillStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcException
extends DrillIOException {
    static final Logger logger = LoggerFactory.getLogger(RpcException.class);

    public RpcException() {
    }

    public RpcException(String message, Throwable cause) {
        super(RpcException.format(message), cause);
    }

    private static String format(String message) {
        return DrillStringUtils.unescapeJava(message);
    }

    public RpcException(String message) {
        super(RpcException.format(message));
    }

    public RpcException(Throwable cause) {
        super(cause);
    }

    public static RpcException mapException(Throwable t) {
        while (t instanceof ExecutionException) {
            t = ((ExecutionException)t).getCause();
        }
        if (t instanceof RpcException) {
            return (RpcException)t;
        }
        return new RpcException(t);
    }

    public static RpcException mapException(String message, Throwable t) {
        while (t instanceof ExecutionException) {
            t = ((ExecutionException)t).getCause();
        }
        return new RpcException(message, t);
    }
}

