/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.common.base.Preconditions;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.rpc.ChannelClosedException;
import org.apache.drill.exec.rpc.ChannelListenerWithCoordinationId;
import org.apache.drill.exec.rpc.CoordinationQueue;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.DrillRpcFutureImpl;
import org.apache.drill.exec.rpc.InboundRpcMessage;
import org.apache.drill.exec.rpc.OutboundRpcMessage;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.ResponseSender;
import org.apache.drill.exec.rpc.RpcConfig;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcOutcome;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcBus<T extends Internal.EnumLite, C extends RemoteConnection>
implements Closeable {
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final CoordinationQueue queue = new CoordinationQueue(16, 16);
    protected final RpcConfig rpcConfig;

    protected abstract MessageLite getResponseDefaultInstance(int var1) throws RpcException;

    protected void handle(C connection, int rpcType, ByteBuf pBody, ByteBuf dBody, ResponseSender sender) throws RpcException {
        sender.send(this.handle(connection, rpcType, pBody, dBody));
    }

    protected abstract Response handle(C var1, int var2, ByteBuf var3, ByteBuf var4) throws RpcException;

    public abstract boolean isClient();

    public RpcBus(RpcConfig rpcConfig) {
        this.rpcConfig = rpcConfig;
    }

    <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        DrillRpcFutureImpl rpcFuture = new DrillRpcFutureImpl();
        this.send(rpcFuture, connection, rpcType, protobufBody, clazz, dataBodies);
        return rpcFuture;
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        this.send(listener, connection, rpcType, protobufBody, clazz, false, dataBodies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, boolean allowInEventLoop, ByteBuf ... dataBodies) {
        block12: {
            if (!allowInEventLoop) {
                if (((RemoteConnection)connection).inEventLoop()) {
                    throw new IllegalStateException("You attempted to send while inside the rpc event thread.  This isn't allowed because sending will block if the channel is backed up.");
                }
                if (!((RemoteConnection)connection).blockOnNotWritable(listener)) {
                    return;
                }
            }
            ReferenceCounted pBuffer = null;
            boolean completed = false;
            try {
                assert (!Arrays.asList(dataBodies).contains(null));
                assert (this.rpcConfig.checkSend((Internal.EnumLite)rpcType, protobufBody.getClass(), clazz));
                Preconditions.checkNotNull(protobufBody);
                ChannelListenerWithCoordinationId futureListener = this.queue.get(listener, clazz, (RemoteConnection)connection);
                OutboundRpcMessage m = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.REQUEST, (Internal.EnumLite)rpcType, futureListener.getCoordinationId(), protobufBody, dataBodies);
                ChannelFuture channelFuture = ((RemoteConnection)connection).getChannel().writeAndFlush(m);
                channelFuture.addListener(futureListener);
                channelFuture.addListener(ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                completed = true;
            }
            catch (AssertionError | Exception e) {
                listener.failed(new RpcException("Failure sending message.", (Throwable)e));
            }
            finally {
                if (completed) break block12;
                if (pBuffer != null) {
                    pBuffer.release();
                }
                if (dataBodies == null) break block12;
                for (ByteBuf b : dataBodies) {
                    b.release();
                }
            }
        }
    }

    public abstract C initRemoteConnection(Channel var1);

    protected void closeQueueDueToChannelClose() {
        if (this.isClient()) {
            this.queue.channelClosed(new ChannelClosedException("Queue closed due to channel closure."));
        }
    }

    protected GenericFutureListener<ChannelFuture> getCloseHandler(C clientConnection) {
        return new ChannelClosedHandler();
    }

    public static <T> T get(ByteBuf pBody, Parser<T> parser) throws RpcException {
        try {
            ByteBufInputStream is = new ByteBufInputStream(pBody);
            return parser.parseFrom(is);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RpcException(String.format("Failure while decoding message with parser of type. %s", parser.getClass().getCanonicalName()), e);
        }
    }

    protected static class InboundHandler
    extends MessageToMessageDecoder<InboundRpcMessage> {
        private final C connection;
        final /* synthetic */ RpcBus this$0;

        public InboundHandler(C connection) {
            this.this$0 = var1_1;
            this.connection = connection;
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, InboundRpcMessage msg, List<Object> output) throws Exception {
            if (!ctx.channel().isOpen()) {
                return;
            }
            switch (msg.mode) {
                case REQUEST: {
                    ResponseSenderImpl sender = this.this$0.new ResponseSenderImpl((RemoteConnection)this.connection, msg.coordinationId);
                    this.this$0.handle(this.connection, msg.rpcType, msg.pBody, msg.dBody, sender);
                    msg.release();
                    break;
                }
                case RESPONSE: {
                    try {
                        MessageLite m = this.this$0.getResponseDefaultInstance(msg.rpcType);
                        assert (this.this$0.rpcConfig.checkReceive(msg.rpcType, m.getClass()));
                        RpcOutcome<?> rpcFuture = this.this$0.queue.getFuture(msg.rpcType, msg.coordinationId, m.getClass());
                        Parser<? extends MessageLite> parser = m.getParserForType();
                        MessageLite value = parser.parseFrom(new ByteBufInputStream(msg.pBody, msg.pBody.readableBytes()));
                        rpcFuture.set(value, msg.dBody);
                        msg.release();
                        break;
                    }
                    catch (Exception ex) {
                        this.this$0.logger.error("Failure while handling response.", ex);
                        throw ex;
                    }
                }
                case RESPONSE_FAILURE: {
                    GeneralRPCProtos.RpcFailure failure = GeneralRPCProtos.RpcFailure.parseFrom(new ByteBufInputStream(msg.pBody, msg.pBody.readableBytes()));
                    this.this$0.queue.updateFailedFuture(msg.coordinationId, failure);
                    msg.release();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }

    private class ResponseSenderImpl
    implements ResponseSender {
        RemoteConnection connection;
        int coordinationId;

        public ResponseSenderImpl(RemoteConnection connection, int coordinationId) {
            this.connection = connection;
            this.coordinationId = coordinationId;
        }

        @Override
        public void send(Response r) {
            assert (RpcBus.this.rpcConfig.checkResponseSend(r.rpcType, r.pBody.getClass()));
            OutboundRpcMessage outMessage = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, r.rpcType, this.coordinationId, r.pBody, r.dBodies);
            this.connection.getChannel().writeAndFlush(outMessage);
        }
    }

    public class ChannelClosedHandler
    implements GenericFutureListener<ChannelFuture> {
        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            RpcBus.this.logger.info("Channel closed between local {} and remote {}", (Object)future.channel().localAddress(), (Object)future.channel().remoteAddress());
            RpcBus.this.closeQueueDueToChannelClose();
        }
    }
}

