/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettableBarrier {
    static final Logger logger = LoggerFactory.getLogger(ResettableBarrier.class);
    private final InternalSynchronizer sync = new InternalSynchronizer();

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public void openBarrier() {
        this.sync.releaseShared(1);
    }

    public void closeBarrier() {
        this.sync.reset();
    }

    private static final class InternalSynchronizer
    extends AbstractQueuedSynchronizer {
        private InternalSynchronizer() {
            this.setState(1);
        }

        @Override
        protected int tryAcquireShared(int acquires) {
            assert (acquires == 1);
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            assert (releases == 1);
            do {
                if ((c = this.getState()) != 0) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c - 1));
            return nextc == 0;
        }

        protected void reset() {
            this.setState(1);
        }
    }
}

