/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.BindException;
import java.util.concurrent.ExecutionException;
import org.apache.drill.exec.exception.DrillbitStartupException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.rpc.AbstractHandshakeHandler;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.OutOfMemoryHandler;
import org.apache.drill.exec.rpc.OutboundRpcMessage;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.Response;
import org.apache.drill.exec.rpc.RpcBus;
import org.apache.drill.exec.rpc.RpcConfig;
import org.apache.drill.exec.rpc.RpcDecoder;
import org.apache.drill.exec.rpc.RpcEncoder;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcExceptionHandler;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.TransportCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicServer<T extends Internal.EnumLite, C extends RemoteConnection>
extends RpcBus<T, C> {
    static final Logger logger = LoggerFactory.getLogger(BasicServer.class);
    private ServerBootstrap b;
    private volatile boolean connect = false;
    private final EventLoopGroup eventLoopGroup;

    public BasicServer(RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup) {
        super(rpcMapping);
        this.eventLoopGroup = eventLoopGroup;
        this.b = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(TransportCheck.getServerSocketChannel())).option(ChannelOption.SO_BACKLOG, 1000)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000)).option(ChannelOption.TCP_NODELAY, true)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, 131072)).option(ChannelOption.SO_SNDBUF, 131072)).group(eventLoopGroup).childOption(ChannelOption.ALLOCATOR, alloc).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                Object connection = BasicServer.this.initRemoteConnection(ch);
                ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)BasicServer.this.getCloseHandler(connection));
                ch.pipeline().addLast(BasicServer.this.getDecoder(((RemoteConnection)connection).getAllocator(), BasicServer.this.getOutOfMemoryHandler()), new RpcDecoder("s-" + BasicServer.this.rpcConfig.getName()), new RpcEncoder("s-" + BasicServer.this.rpcConfig.getName()), BasicServer.this.getHandshakeHandler(connection), new RpcBus.InboundHandler((RpcBus)BasicServer.this, connection), new RpcExceptionHandler());
                BasicServer.this.connect = true;
            }
        });
    }

    public OutOfMemoryHandler getOutOfMemoryHandler() {
        return OutOfMemoryHandler.DEFAULT_INSTANCE;
    }

    public abstract ProtobufLengthDecoder getDecoder(BufferAllocator var1, OutOfMemoryHandler var2);

    @Override
    public boolean isClient() {
        return false;
    }

    protected abstract ServerHandshakeHandler<?> getHandshakeHandler(C var1);

    @Override
    protected MessageLite getResponseDefaultInstance(int rpcType) throws RpcException {
        return null;
    }

    @Override
    protected Response handle(C connection, int rpcType, ByteBuf pBody, ByteBuf dBody) throws RpcException {
        return null;
    }

    @Override
    public <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(connection, rpcType, protobufBody, clazz, dataBodies);
    }

    @Override
    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, C connection, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        super.send(listener, connection, rpcType, protobufBody, clazz, dataBodies);
    }

    @Override
    public C initRemoteConnection(Channel channel) {
        return null;
    }

    public int bind(int initialPort, boolean allowPortHunting) throws InterruptedException, DrillbitStartupException {
        int port = initialPort - 1;
        while (true) {
            try {
                this.b.bind(++port).sync();
            }
            catch (Exception e) {
                if (e instanceof BindException && allowPortHunting) continue;
                throw new DrillbitStartupException("Could not bind Drillbit", e);
            }
            break;
        }
        this.connect = !this.connect;
        logger.debug("Server started on port {} of type {} ", (Object)port, (Object)this.getClass().getSimpleName());
        return port;
    }

    @Override
    public void close() throws IOException {
        try {
            this.eventLoopGroup.shutdownGracefully().get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Failure while shutting down {}. ", (Object)this.getClass().getName(), (Object)e);
        }
    }

    protected static abstract class ServerHandshakeHandler<T extends MessageLite>
    extends AbstractHandshakeHandler<T> {
        public ServerHandshakeHandler(Internal.EnumLite handshakeType, Parser<T> parser) {
            super(handshakeType, parser);
        }

        @Override
        protected final void consumeHandshake(ChannelHandlerContext ctx, T inbound) throws Exception {
            OutboundRpcMessage msg = new OutboundRpcMessage(GeneralRPCProtos.RpcMode.RESPONSE, this.handshakeType, this.coordinationId, this.getHandshakeResponse(inbound), new ByteBuf[0]);
            ctx.writeAndFlush(msg);
        }

        public abstract MessageLite getHandshakeResponse(T var1) throws Exception;
    }
}

