/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutionException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.rpc.AbstractHandshakeHandler;
import org.apache.drill.exec.rpc.BasicClient;
import org.apache.drill.exec.rpc.DrillRpcFuture;
import org.apache.drill.exec.rpc.ProtobufLengthDecoder;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.RpcBus;
import org.apache.drill.exec.rpc.RpcConfig;
import org.apache.drill.exec.rpc.RpcConnectionHandler;
import org.apache.drill.exec.rpc.RpcDecoder;
import org.apache.drill.exec.rpc.RpcEncoder;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.RpcExceptionHandler;
import org.apache.drill.exec.rpc.RpcOutcome;
import org.apache.drill.exec.rpc.RpcOutcomeListener;
import org.apache.drill.exec.rpc.TransportCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicClient<T extends Internal.EnumLite, R extends RemoteConnection, HANDSHAKE_SEND extends MessageLite, HANDSHAKE_RESPONSE extends MessageLite>
extends RpcBus<T, R> {
    static final Logger logger = LoggerFactory.getLogger(BasicClient.class);
    private final Bootstrap b;
    private volatile boolean connect = false;
    protected R connection;
    private final T handshakeType;
    private final Class<HANDSHAKE_RESPONSE> responseClass;
    private final Parser<HANDSHAKE_RESPONSE> handshakeParser;

    public BasicClient(RpcConfig rpcMapping, ByteBufAllocator alloc, EventLoopGroup eventLoopGroup, T handshakeType, Class<HANDSHAKE_RESPONSE> responseClass, Parser<HANDSHAKE_RESPONSE> handshakeParser) {
        super(rpcMapping);
        this.responseClass = responseClass;
        this.handshakeType = handshakeType;
        this.handshakeParser = handshakeParser;
        this.b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(TransportCheck.getClientSocketChannel())).option(ChannelOption.ALLOCATOR, alloc)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 30000)).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, 131072)).option(ChannelOption.SO_SNDBUF, 131072)).option(ChannelOption.TCP_NODELAY, true)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                BasicClient.this.connection = BasicClient.this.initRemoteConnection(ch);
                ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)BasicClient.this.getCloseHandler(BasicClient.this.connection));
                ch.pipeline().addLast(BasicClient.this.getDecoder(((RemoteConnection)BasicClient.this.connection).getAllocator()), new RpcDecoder("c-" + BasicClient.this.rpcConfig.getName()), new RpcEncoder("c-" + BasicClient.this.rpcConfig.getName()), new ClientHandshakeHandler(), new RpcBus.InboundHandler((RpcBus)BasicClient.this, BasicClient.this.connection), new RpcExceptionHandler());
                BasicClient.this.connect = true;
            }
        });
    }

    public abstract ProtobufLengthDecoder getDecoder(BufferAllocator var1);

    protected abstract void validateHandshake(HANDSHAKE_RESPONSE var1) throws RpcException;

    protected abstract void finalizeConnection(HANDSHAKE_RESPONSE var1, R var2);

    @Override
    protected GenericFutureListener<ChannelFuture> getCloseHandler(Channel channel) {
        return new RpcBus.ChannelClosedHandler(this);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> void send(RpcOutcomeListener<RECEIVE> listener, T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        super.send(listener, this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    public <SEND extends MessageLite, RECEIVE extends MessageLite> DrillRpcFuture<RECEIVE> send(T rpcType, SEND protobufBody, Class<RECEIVE> clazz, ByteBuf ... dataBodies) {
        return super.send(this.connection, rpcType, protobufBody, clazz, dataBodies);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    protected void connectAsClient(RpcConnectionHandler<R> connectionListener, HANDSHAKE_SEND handshakeValue, String host, int port) {
        ConnectionMultiListener cml = new ConnectionMultiListener(this, connectionListener, handshakeValue);
        this.b.connect(host, port).addListener((GenericFutureListener<? extends Future<? super Void>>)cml.connectionHandler);
    }

    public void setAutoRead(boolean enableAutoRead) {
        ((RemoteConnection)this.connection).setAutoRead(enableAutoRead);
    }

    @Override
    public void close() {
        logger.debug("Closing client");
        try {
            ((RemoteConnection)this.connection).getChannel().close().get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.warn("Failure whiel shutting {}", (Object)this.getClass().getName(), (Object)e);
        }
    }

    private class ClientHandshakeHandler
    extends AbstractHandshakeHandler<HANDSHAKE_RESPONSE> {
        public ClientHandshakeHandler() {
            super(BasicClient.this.handshakeType, BasicClient.this.handshakeParser);
        }

        @Override
        protected final void consumeHandshake(ChannelHandlerContext ctx, HANDSHAKE_RESPONSE msg) throws Exception {
            RpcOutcome response = BasicClient.this.queue.getFuture(this.handshakeType.getNumber(), this.coordinationId, BasicClient.this.responseClass);
            response.set(msg, null);
        }
    }

    private static class ConnectionMultiListener {
        private final RpcConnectionHandler<R> l;
        private final HANDSHAKE_SEND handshakeValue;
        public final org.apache.drill.exec.rpc.BasicClient$ConnectionMultiListener.ConnectionHandler connectionHandler = new ConnectionHandler();
        public final org.apache.drill.exec.rpc.BasicClient$ConnectionMultiListener.HandshakeSendHandler handshakeSendHandler = new HandshakeSendHandler();
        final /* synthetic */ BasicClient this$0;

        public ConnectionMultiListener(RpcConnectionHandler<R> l, HANDSHAKE_SEND handshakeValue) {
            this.this$0 = var1_1;
            assert (l != null);
            assert (handshakeValue != null);
            this.l = l;
            this.handshakeValue = handshakeValue;
        }

        private class HandshakeSendHandler
        implements RpcOutcomeListener<HANDSHAKE_RESPONSE> {
            private HandshakeSendHandler() {
            }

            @Override
            public void failed(RpcException ex) {
                logger.debug("Failure while initiating handshake", ex);
                ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_COMMUNICATION, ex);
            }

            @Override
            public void success(HANDSHAKE_RESPONSE value, ByteBuf buffer) {
                try {
                    ConnectionMultiListener.this.this$0.validateHandshake(value);
                    ConnectionMultiListener.this.this$0.finalizeConnection(value, ConnectionMultiListener.this.this$0.connection);
                    ConnectionMultiListener.this.this$0.connect = true;
                    ConnectionMultiListener.this.l.connectionSucceeded(ConnectionMultiListener.this.this$0.connection);
                }
                catch (RpcException ex) {
                    ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.HANDSHAKE_VALIDATION, ex);
                }
            }
        }

        private class ConnectionHandler
        implements GenericFutureListener<ChannelFuture> {
            private ConnectionHandler() {
            }

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                try {
                    future.get();
                    if (future.isSuccess()) {
                        ConnectionMultiListener.this.this$0.send(ConnectionMultiListener.this.handshakeSendHandler, ConnectionMultiListener.this.this$0.connection, ConnectionMultiListener.this.this$0.handshakeType, ConnectionMultiListener.this.handshakeValue, ConnectionMultiListener.this.this$0.responseClass, true, new ByteBuf[0]);
                    } else {
                        ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, new RpcException("General connection failure."));
                    }
                }
                catch (Exception ex) {
                    ConnectionMultiListener.this.l.connectionFailed(RpcConnectionHandler.FailureType.CONNECTION, ex);
                }
            }
        }
    }
}

