/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resolver;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.resolver.ResolverTypePrecedence;
import org.apache.drill.exec.util.DecimalUtility;

public class TypeCastRules {
    private static Map<TypeProtos.MinorType, Set<TypeProtos.MinorType>> rules;

    private static void initTypeRules() {
        rules = new HashMap<TypeProtos.MinorType, Set<TypeProtos.MinorType>>();
        HashSet<TypeProtos.MinorType> rule = new HashSet<TypeProtos.MinorType>();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.TINYINT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.SMALLINT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.INT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.BIGINT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.UINT8, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.DECIMAL9, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.DECIMAL18, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.DECIMAL28DENSE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.DECIMAL28SPARSE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.DECIMAL38DENSE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.DECIMAL38SPARSE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.MONEY, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.DATE, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.TIME, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rules.put(TypeProtos.MinorType.TIMESTAMP, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.TIMESTAMPTZ, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.INTERVAL, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.INTERVALYEAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rules.put(TypeProtos.MinorType.INTERVALDAY, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rules.put(TypeProtos.MinorType.FLOAT4, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rules.put(TypeProtos.MinorType.FLOAT8, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rules.put(TypeProtos.MinorType.BIT, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rules.put(TypeProtos.MinorType.FIXEDCHAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rules.put(TypeProtos.MinorType.FIXED16CHAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rules.put(TypeProtos.MinorType.FIXEDBINARY, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rules.put(TypeProtos.MinorType.VARCHAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.FIXEDCHAR);
        rule.add(TypeProtos.MinorType.FIXED16CHAR);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VAR16CHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rule.add(TypeProtos.MinorType.DATE);
        rule.add(TypeProtos.MinorType.TIME);
        rule.add(TypeProtos.MinorType.TIMESTAMP);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.INTERVAL);
        rule.add(TypeProtos.MinorType.INTERVALYEAR);
        rule.add(TypeProtos.MinorType.INTERVALDAY);
        rules.put(TypeProtos.MinorType.VAR16CHAR, rule);
        rule = new HashSet();
        rule.add(TypeProtos.MinorType.TINYINT);
        rule.add(TypeProtos.MinorType.SMALLINT);
        rule.add(TypeProtos.MinorType.INT);
        rule.add(TypeProtos.MinorType.BIGINT);
        rule.add(TypeProtos.MinorType.UINT1);
        rule.add(TypeProtos.MinorType.UINT2);
        rule.add(TypeProtos.MinorType.UINT4);
        rule.add(TypeProtos.MinorType.UINT8);
        rule.add(TypeProtos.MinorType.DECIMAL9);
        rule.add(TypeProtos.MinorType.DECIMAL18);
        rule.add(TypeProtos.MinorType.DECIMAL28SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL28DENSE);
        rule.add(TypeProtos.MinorType.DECIMAL38SPARSE);
        rule.add(TypeProtos.MinorType.DECIMAL38DENSE);
        rule.add(TypeProtos.MinorType.MONEY);
        rule.add(TypeProtos.MinorType.TIMESTAMPTZ);
        rule.add(TypeProtos.MinorType.FLOAT4);
        rule.add(TypeProtos.MinorType.FLOAT8);
        rule.add(TypeProtos.MinorType.BIT);
        rule.add(TypeProtos.MinorType.VARCHAR);
        rule.add(TypeProtos.MinorType.VARBINARY);
        rule.add(TypeProtos.MinorType.FIXEDBINARY);
        rules.put(TypeProtos.MinorType.VARBINARY, rule);
    }

    public static boolean isCastableWithNullHandling(TypeProtos.MajorType from, TypeProtos.MajorType to, FunctionTemplate.NullHandling nullHandling) {
        if (nullHandling == FunctionTemplate.NullHandling.INTERNAL && from.getMode() != to.getMode()) {
            return false;
        }
        return TypeCastRules.isCastable(from.getMinorType(), to.getMinorType());
    }

    private static boolean isCastable(TypeProtos.MinorType from, TypeProtos.MinorType to) {
        return from.equals(TypeProtos.MinorType.NULL) || rules.get(to) != null && rules.get(to).contains(from);
    }

    public static TypeProtos.MinorType getLeastRestrictiveType(List<TypeProtos.MinorType> types) {
        assert (types.size() >= 2);
        TypeProtos.MinorType result = types.get(0);
        int resultPrec = ResolverTypePrecedence.precedenceMap.get(result);
        for (int i = 1; i < types.size(); ++i) {
            TypeProtos.MinorType next = types.get(i);
            if (next == result) continue;
            int nextPrec = ResolverTypePrecedence.precedenceMap.get(next);
            if (TypeCastRules.isCastable(next, result) && resultPrec >= nextPrec) continue;
            if (TypeCastRules.isCastable(result, next) && nextPrec >= resultPrec) {
                result = next;
                resultPrec = nextPrec;
                continue;
            }
            throw new DrillRuntimeException("Case expression branches have different output types ");
        }
        return result;
    }

    public static int getCost(FunctionCall call, DrillFuncHolder holder) {
        int cost = 0;
        if (call.args.size() != holder.getParamCount()) {
            return -1;
        }
        boolean secondaryCast = false;
        int nCasts = 0;
        if (holder.checkPrecisionRange() && DecimalUtility.getMaxPrecision(holder.getReturnType().getMinorType()) < holder.getReturnType(call.args).getPrecision()) {
            return -1;
        }
        for (int i = 0; i < holder.getParamCount(); ++i) {
            int castCost;
            TypeProtos.MajorType argType = ((LogicalExpression)call.args.get(i)).getMajorType();
            TypeProtos.MajorType parmType = holder.getParmMajorType(i);
            if (holder.isFieldReader(i)) continue;
            if (!TypeCastRules.isCastableWithNullHandling(argType, parmType, holder.getNullHandling())) {
                return -1;
            }
            Integer parmVal = ResolverTypePrecedence.precedenceMap.get(parmType.getMinorType());
            Integer argVal = ResolverTypePrecedence.precedenceMap.get(argType.getMinorType());
            if (parmVal == null) {
                throw new RuntimeException(String.format("Precedence for type %s is not defined", parmType.getMinorType().name()));
            }
            if (argVal == null) {
                throw new RuntimeException(String.format("Precedence for type %s is not defined", argType.getMinorType().name()));
            }
            if (parmVal - argVal < 0) {
                Set<TypeProtos.MinorType> rules = ResolverTypePrecedence.secondaryImplicitCastRules.get(parmType.getMinorType());
                if (rules != null && rules.contains(argType.getMinorType())) {
                    secondaryCast = true;
                } else {
                    return -1;
                }
            }
            if (argType.getMode() != parmType.getMode() && holder.getNullHandling() == FunctionTemplate.NullHandling.INTERNAL) {
                if (parmType.getMode() == TypeProtos.DataMode.REQUIRED && argType.getMode() == TypeProtos.DataMode.OPTIONAL) {
                    return -1;
                }
                if (parmType.getMode() == TypeProtos.DataMode.OPTIONAL && argType.getMode() == TypeProtos.DataMode.REQUIRED) {
                    ++cost;
                }
            }
            if ((castCost = parmVal - argVal) < 0) continue;
            ++nCasts;
            cost += castCost;
        }
        if (secondaryCast) {
            int secondaryCastCost = 0x7FFFFFFE;
            secondaryCastCost -= nCasts * (ResolverTypePrecedence.MAX_IMPLICIT_CAST_COST + 1);
            return secondaryCastCost += cost;
        }
        return cost;
    }

    static {
        TypeCastRules.initTypeRules();
    }
}

