/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.resolver;

import java.util.List;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.exec.expr.fn.DrillFuncHolder;
import org.apache.drill.exec.resolver.FunctionResolver;
import org.apache.drill.exec.resolver.TypeCastRules;

public class DefaultFunctionResolver
implements FunctionResolver {
    @Override
    public DrillFuncHolder getBestMatch(List<DrillFuncHolder> methods, FunctionCall call) {
        int bestcost = Integer.MAX_VALUE;
        int currcost = Integer.MAX_VALUE;
        DrillFuncHolder bestmatch = null;
        for (DrillFuncHolder h : methods) {
            currcost = TypeCastRules.getCost(call, h);
            if (currcost < 0 || currcost >= bestcost) continue;
            bestcost = currcost;
            bestmatch = h;
        }
        if (bestcost < 0) {
            return null;
        }
        return bestmatch;
    }
}

