/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.selection;

import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.record.DeadBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionVector4 {
    static final Logger logger = LoggerFactory.getLogger(SelectionVector4.class);
    private ByteBuf data;
    private int recordCount;
    private int start;
    private int length;

    public SelectionVector4(ByteBuf vector, int recordCount, int batchRecordCount) throws SchemaChangeException {
        if (recordCount > 0x1FFFFFFF) {
            throw new SchemaChangeException(String.format("Currently, Drill can only support allocations up to 2gb in size.  You requested an allocation of %d bytes.", recordCount * 4));
        }
        this.recordCount = recordCount;
        this.start = 0;
        this.length = Math.min(batchRecordCount, recordCount);
        this.data = vector;
    }

    public void set(int index, int compound) {
        this.data.setInt(index * 4, compound);
    }

    public void set(int index, int recordBatch, int recordIndex) {
        this.data.setInt(index * 4, recordBatch << 16 | recordIndex & 0xFFFF);
    }

    public int get(int index) {
        return this.data.getInt((this.start + index) * 4);
    }

    public void clear() {
        this.start = 0;
        this.length = 0;
        if (this.data != DeadBuf.DEAD_BUFFER) {
            this.data.release();
            this.data = DeadBuf.DEAD_BUFFER;
        }
    }
}

