/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record.selection;

import io.netty.buffer.DrillBuf;
import java.io.Closeable;
import java.io.IOException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.record.DeadBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionVector2
implements Closeable {
    static final Logger logger = LoggerFactory.getLogger(SelectionVector2.class);
    private final BufferAllocator allocator;
    private int recordCount;
    private DrillBuf buffer = DeadBuf.DEAD_BUFFER;

    public SelectionVector2(BufferAllocator allocator) {
        this.allocator = allocator;
    }

    public SelectionVector2 clone() {
        SelectionVector2 newSV = new SelectionVector2(this.allocator);
        newSV.recordCount = this.recordCount;
        newSV.buffer = this.buffer;
        newSV.buffer.retain();
        this.clear();
        return newSV;
    }

    public void clear() {
        if (this.buffer != null && this.buffer != DeadBuf.DEAD_BUFFER) {
            this.buffer.release();
            this.buffer = DeadBuf.DEAD_BUFFER;
            this.recordCount = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }
}

