/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.HyperVectorWrapper;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.SchemaBuilder;
import org.apache.drill.exec.record.SimpleVectorWrapper;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.complex.AbstractMapVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorContainer
extends AbstractMapVector
implements Iterable<VectorWrapper<?>>,
VectorAccessible {
    static final Logger logger = LoggerFactory.getLogger(VectorContainer.class);
    protected final List<VectorWrapper<?>> wrappers = Lists.newArrayList();
    private BatchSchema schema;
    private int recordCount = -1;
    private final OperatorContext oContext = null;

    public static VectorContainer canonicalize(VectorContainer original) {
        VectorContainer vc = new VectorContainer();
        ArrayList canonicalWrappers = new ArrayList(original.wrappers);
        Collections.sort(canonicalWrappers, new Comparator<VectorWrapper<?>>(){

            @Override
            public int compare(VectorWrapper<?> v1, VectorWrapper<?> v2) {
                return v1.getField().getPath().toExpr().compareTo(v2.getField().getPath().toExpr());
            }
        });
        for (VectorWrapper vectorWrapper : canonicalWrappers) {
            vc.add((ValueVector)vectorWrapper.getValueVector());
        }
        return vc;
    }

    public void addCollection(Iterable<ValueVector> vectors) {
        this.schema = null;
        for (ValueVector vv : vectors) {
            this.wrappers.add(SimpleVectorWrapper.create(vv));
        }
    }

    public TypedFieldId add(ValueVector vv) {
        this.schema = null;
        int i = this.wrappers.size();
        this.wrappers.add(SimpleVectorWrapper.create(vv));
        return new TypedFieldId(vv.getField().getType(), i);
    }

    public void add(ValueVector[] hyperVector, boolean releasable) {
        assert (hyperVector.length != 0);
        this.schema = null;
        Class<?> clazz = hyperVector[0].getClass();
        ValueVector[] c = (ValueVector[])Array.newInstance(clazz, hyperVector.length);
        for (int i = 0; i < hyperVector.length; ++i) {
            c[i] = hyperVector[i];
        }
        this.wrappers.add(HyperVectorWrapper.create((MaterializedField)hyperVector[0].getField(), (ValueVector[])c, (boolean)releasable));
    }

    @Override
    public TypedFieldId getValueVectorId(SchemaPath path) {
        for (int i = 0; i < this.wrappers.size(); ++i) {
            VectorWrapper<?> va = this.wrappers.get(i);
            TypedFieldId id = va.getFieldIdIfMatches(i, path);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public VectorWrapper<?> getValueAccessorById(Class<?> clazz, int ... fieldIds) {
        Preconditions.checkArgument(fieldIds.length >= 1);
        VectorWrapper<?> va = this.wrappers.get(fieldIds[0]);
        if (va == null) {
            return null;
        }
        if (fieldIds.length == 1 && clazz != null && !clazz.isAssignableFrom(va.getVectorClass())) {
            throw new IllegalStateException(String.format("Failure while reading vector.  Expected vector class of %s but was holding vector class %s.", clazz.getCanonicalName(), va.getVectorClass().getCanonicalName()));
        }
        return va.getChildWrapper(fieldIds);
    }

    @Override
    public BatchSchema getSchema() {
        Preconditions.checkNotNull(this.schema, "Schema is currently null.  You must call buildSchema(SelectionVectorMode) before this container can return a schema.");
        return this.schema;
    }

    public void buildSchema(BatchSchema.SelectionVectorMode mode) {
        SchemaBuilder bldr = BatchSchema.newBuilder().setSelectionVectorMode(mode);
        for (VectorWrapper<?> v : this.wrappers) {
            bldr.addField(v.getField());
        }
        this.schema = bldr.build();
    }

    @Override
    public Iterator<VectorWrapper<?>> iterator() {
        return this.wrappers.iterator();
    }

    public void clear() {
        this.schema = null;
        this.zeroVectors();
        this.wrappers.clear();
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    @Override
    public int getRecordCount() {
        if (this.recordCount < 0) {
            System.out.println();
        }
        Preconditions.checkState(this.recordCount != -1, "Record count not set for this vector container");
        return this.recordCount;
    }

    public void zeroVectors() {
        for (VectorWrapper<?> w : this.wrappers) {
            w.clear();
        }
    }

    public void allocateNew() {
        for (VectorWrapper<?> w : this.wrappers) {
            w.getValueVector().allocateNew();
        }
    }
}

