/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;

public class SchemaBuilder {
    private List<MaterializedField> fields = Lists.newArrayList();
    private BatchSchema.SelectionVectorMode selectionVectorMode = BatchSchema.SelectionVectorMode.NONE;

    SchemaBuilder() {
    }

    public SchemaBuilder setSelectionVectorMode(BatchSchema.SelectionVectorMode selectionVectorMode) {
        this.selectionVectorMode = selectionVectorMode;
        return this;
    }

    public SchemaBuilder addField(MaterializedField f) {
        this.fields.add(f);
        return this;
    }

    public BatchSchema build() {
        ArrayList<MaterializedField> fieldList = Lists.newArrayList(this.fields);
        return new BatchSchema(this.selectionVectorMode, fieldList);
    }
}

