/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.rpc.RemoteConnection;
import org.apache.drill.exec.rpc.ResponseSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawFragmentBatch {
    static final Logger logger = LoggerFactory.getLogger(RawFragmentBatch.class);
    final RemoteConnection connection;
    final BitData.FragmentRecordBatch header;
    final DrillBuf body;
    final ResponseSender sender;

    public RawFragmentBatch(RemoteConnection connection, BitData.FragmentRecordBatch header, DrillBuf body, ResponseSender sender) {
        this.header = header;
        this.body = body;
        this.connection = connection;
        this.sender = sender;
        if (body != null) {
            body.retain();
        }
    }

    public BitData.FragmentRecordBatch getHeader() {
        return this.header;
    }

    public DrillBuf getBody() {
        return this.body;
    }

    public String toString() {
        return "RawFragmentBatch [header=" + this.header + ", body=" + this.body + "]";
    }

    public void release() {
        if (this.body != null) {
            this.body.release();
        }
    }

    public long getByteCount() {
        return this.body == null ? 0L : (long)this.body.readableBytes();
    }
}

