/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.proto.UserBitShared;

public class MaterializedField {
    private Key key;
    private List<MaterializedField> children = Lists.newArrayList();

    private MaterializedField(SchemaPath path, TypeProtos.MajorType type) {
        this.key = new Key(path, type);
    }

    public static MaterializedField create(UserBitShared.SerializedField serField) {
        return new MaterializedField(SchemaPath.create(serField.getNamePart()), serField.getMajorType());
    }

    public UserBitShared.SerializedField.Builder getAsBuilder() {
        return UserBitShared.SerializedField.newBuilder().setMajorType(this.key.type).setNamePart(this.key.path.getAsNamePart());
    }

    public void addChild(MaterializedField field) {
        this.children.add(field);
    }

    public MaterializedField clone(FieldReference ref) {
        return MaterializedField.create(ref, this.key.type);
    }

    public String getLastName() {
        PathSegment seg = this.key.path.getRootSegment();
        while (seg.getChild() != null) {
            seg = seg.getChild();
        }
        return ((PathSegment)seg).getNameSegment().getPath();
    }

    public boolean matches(UserBitShared.SerializedField field) {
        MaterializedField f = MaterializedField.create(field);
        return f.equals(this);
    }

    public static MaterializedField create(String path, TypeProtos.MajorType type) {
        SchemaPath p = SchemaPath.getSimplePath(path);
        return MaterializedField.create(p, type);
    }

    public static MaterializedField create(SchemaPath path, TypeProtos.MajorType type) {
        return new MaterializedField(path, type);
    }

    public SchemaPath getPath() {
        return this.key.path;
    }

    @Deprecated
    public SchemaPath getAsSchemaPath() {
        return this.getPath();
    }

    public TypeProtos.MajorType getType() {
        return this.key.type;
    }

    public int getScale() {
        return this.key.type.getScale();
    }

    public TypeProtos.DataMode getDataMode() {
        return this.key.type.getMode();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.children == null ? 0 : this.children.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedField other = (MaterializedField)obj;
        if (this.children == null ? other.children != null : !this.children.equals(other.children)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }

    public String toString() {
        return "MaterializedField [path=" + this.key.path + ", type=" + Types.toString(this.key.type) + "]";
    }

    public class Key {
        private SchemaPath path;
        private TypeProtos.MajorType type;

        private Key(SchemaPath path, TypeProtos.MajorType type) {
            this.path = path;
            this.type = type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

