/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.drill.common.types.TypeProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MajorTypeSerDe {
    static final Logger logger = LoggerFactory.getLogger(MajorTypeSerDe.class);

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class MajorTypeHolder {
        @JsonProperty(value="type")
        public TypeProtos.MinorType minorType;
        public TypeProtos.DataMode mode;
        public Integer width;
        public Integer precision;
        public Integer scale;

        private MajorTypeHolder() {
        }

        @JsonIgnore
        public TypeProtos.MajorType getMajorType() {
            TypeProtos.MajorType.Builder b = TypeProtos.MajorType.newBuilder();
            b.setMode(this.mode);
            b.setMinorType(this.minorType);
            if (this.precision != null) {
                b.setPrecision(this.precision);
            }
            if (this.width != null) {
                b.setWidth(this.width);
            }
            if (this.scale != null) {
                b.setScale(this.scale);
            }
            return b.build();
        }

        public static MajorTypeHolder get(TypeProtos.MajorType mt) {
            MajorTypeHolder h = new MajorTypeHolder();
            h.minorType = mt.getMinorType();
            h.mode = mt.getMode();
            if (mt.hasPrecision()) {
                h.precision = mt.getPrecision();
            }
            if (mt.hasScale()) {
                h.scale = mt.getScale();
            }
            if (mt.hasWidth()) {
                h.width = mt.getWidth();
            }
            return h;
        }
    }

    public static class Se
    extends StdSerializer<TypeProtos.MajorType> {
        public Se() {
            super(TypeProtos.MajorType.class);
        }

        public void serialize(TypeProtos.MajorType value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            MajorTypeHolder holder = MajorTypeHolder.get(value);
            jgen.writeObject(holder);
        }
    }

    public static class De
    extends StdDeserializer<TypeProtos.MajorType> {
        public De() {
            super(TypeProtos.MajorType.class);
        }

        @Override
        public TypeProtos.MajorType deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return jp.readValueAs(MajorTypeHolder.class).getMajorType();
        }
    }
}

