/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.apache.drill.exec.proto.BitData;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.WritableBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentWritableBatch {
    static final Logger logger = LoggerFactory.getLogger(FragmentWritableBatch.class);
    private static UserBitShared.RecordBatchDef EMPTY_DEF = UserBitShared.RecordBatchDef.newBuilder().setRecordCount(0).build();
    private final ByteBuf[] buffers;
    private final BitData.FragmentRecordBatch header;

    public FragmentWritableBatch(boolean isLast, UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int receiveMinorFragmentId, WritableBatch batch) {
        this(isLast, queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, receiveMinorFragmentId, batch.getDef(), batch.getBuffers());
    }

    private FragmentWritableBatch(boolean isLast, UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int receiveMinorFragmentId, UserBitShared.RecordBatchDef def, ByteBuf ... buffers) {
        this.buffers = buffers;
        ExecProtos.FragmentHandle handle = ExecProtos.FragmentHandle.newBuilder().setMajorFragmentId(receiveMajorFragmentId).setMinorFragmentId(receiveMinorFragmentId).setQueryId(queryId).build();
        this.header = BitData.FragmentRecordBatch.newBuilder().setIsLastBatch(isLast).setDef(def).setHandle(handle).setSendingMajorFragmentId(sendMajorFragmentId).setSendingMinorFragmentId(sendMinorFragmentId).build();
    }

    public static FragmentWritableBatch getEmptyLast(UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int receiveMinorFragmentId) {
        return new FragmentWritableBatch(true, queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, receiveMinorFragmentId, EMPTY_DEF, new ByteBuf[0]);
    }

    public static FragmentWritableBatch getEmptyLastWithSchema(UserBitShared.QueryId queryId, int sendMajorFragmentId, int sendMinorFragmentId, int receiveMajorFragmentId, int receiveMinorFragmentId, BatchSchema schema) {
        ArrayList<UserBitShared.SerializedField> fields = Lists.newArrayList();
        for (MaterializedField field : schema) {
            fields.add(field.getAsBuilder().build());
        }
        UserBitShared.RecordBatchDef def = UserBitShared.RecordBatchDef.newBuilder().addAllField(fields).build();
        return new FragmentWritableBatch(true, queryId, sendMajorFragmentId, sendMinorFragmentId, receiveMajorFragmentId, receiveMinorFragmentId, def, new ByteBuf[0]);
    }

    public ByteBuf[] getBuffers() {
        return this.buffers;
    }

    public long getByteCount() {
        long n = 0L;
        for (ByteBuf buf : this.buffers) {
            n += (long)buf.readableBytes();
        }
        return n;
    }

    public BitData.FragmentRecordBatch getHeader() {
        return this.header;
    }
}

