/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.record;

import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.HyperVectorWrapper;
import org.apache.drill.exec.record.VectorAccessible;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.vector.ValueVector;

public class ExpandableHyperContainer
extends VectorContainer {
    public ExpandableHyperContainer() {
    }

    public ExpandableHyperContainer(VectorAccessible batch) {
        if (batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            for (VectorWrapper w : batch) {
                ValueVector[] hyperVector = w.getValueVectors();
                this.add(hyperVector, true);
            }
        } else {
            for (VectorWrapper w : batch) {
                ValueVector[] hyperVector = new ValueVector[]{w.getValueVector()};
                this.add(hyperVector, true);
            }
        }
    }

    public void addBatch(VectorAccessible batch) {
        if (batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE) {
            int i = 0;
            for (VectorWrapper w : batch) {
                HyperVectorWrapper hyperVectorWrapper = (HyperVectorWrapper)this.wrappers.get(i++);
                hyperVectorWrapper.addVectors(w.getValueVectors());
            }
        } else {
            int i = 0;
            for (VectorWrapper w : batch) {
                HyperVectorWrapper hyperVectorWrapper = (HyperVectorWrapper)this.wrappers.get(i++);
                hyperVectorWrapper.addVector((ValueVector)w.getValueVector());
            }
        }
    }
}

