/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.proto.beans;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.Message;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Schema;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.drill.exec.proto.beans.DrillPBError;
import org.apache.drill.exec.proto.beans.NodeStatus;
import org.apache.drill.exec.proto.beans.QueryId;
import org.apache.drill.exec.proto.beans.RecordBatchDef;

public final class QueryResult
implements Message<QueryResult>,
Schema<QueryResult>,
Externalizable {
    static final QueryResult DEFAULT_INSTANCE = new QueryResult();
    private QueryState queryState;
    private QueryId queryId;
    private Boolean isLastChunk;
    private int rowCount;
    private long recordsScan;
    private long recordsError;
    private long submissionTime;
    private List<NodeStatus> nodeStatus;
    private List<DrillPBError> error;
    private RecordBatchDef def;
    private Boolean schemaChanged;
    private static final HashMap<String, Integer> __fieldMap = new HashMap();

    public static Schema<QueryResult> getSchema() {
        return DEFAULT_INSTANCE;
    }

    public static QueryResult getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public QueryState getQueryState() {
        return this.queryState == null ? QueryState.PENDING : this.queryState;
    }

    public QueryResult setQueryState(QueryState queryState) {
        this.queryState = queryState;
        return this;
    }

    public QueryId getQueryId() {
        return this.queryId;
    }

    public QueryResult setQueryId(QueryId queryId) {
        this.queryId = queryId;
        return this;
    }

    public Boolean getIsLastChunk() {
        return this.isLastChunk;
    }

    public QueryResult setIsLastChunk(Boolean isLastChunk) {
        this.isLastChunk = isLastChunk;
        return this;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public QueryResult setRowCount(int rowCount) {
        this.rowCount = rowCount;
        return this;
    }

    public long getRecordsScan() {
        return this.recordsScan;
    }

    public QueryResult setRecordsScan(long recordsScan) {
        this.recordsScan = recordsScan;
        return this;
    }

    public long getRecordsError() {
        return this.recordsError;
    }

    public QueryResult setRecordsError(long recordsError) {
        this.recordsError = recordsError;
        return this;
    }

    public long getSubmissionTime() {
        return this.submissionTime;
    }

    public QueryResult setSubmissionTime(long submissionTime) {
        this.submissionTime = submissionTime;
        return this;
    }

    public List<NodeStatus> getNodeStatusList() {
        return this.nodeStatus;
    }

    public QueryResult setNodeStatusList(List<NodeStatus> nodeStatus) {
        this.nodeStatus = nodeStatus;
        return this;
    }

    public List<DrillPBError> getErrorList() {
        return this.error;
    }

    public QueryResult setErrorList(List<DrillPBError> error) {
        this.error = error;
        return this;
    }

    public RecordBatchDef getDef() {
        return this.def;
    }

    public QueryResult setDef(RecordBatchDef def) {
        this.def = def;
        return this;
    }

    public Boolean getSchemaChanged() {
        return this.schemaChanged;
    }

    public QueryResult setSchemaChanged(Boolean schemaChanged) {
        this.schemaChanged = schemaChanged;
        return this;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        GraphIOUtil.mergeDelimitedFrom(in, this, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        GraphIOUtil.writeDelimitedTo(out, this, this);
    }

    @Override
    public Schema<QueryResult> cachedSchema() {
        return DEFAULT_INSTANCE;
    }

    @Override
    public QueryResult newMessage() {
        return new QueryResult();
    }

    public Class<QueryResult> typeClass() {
        return QueryResult.class;
    }

    public String messageName() {
        return QueryResult.class.getSimpleName();
    }

    @Override
    public String messageFullName() {
        return QueryResult.class.getName();
    }

    @Override
    public boolean isInitialized(QueryResult message) {
        return true;
    }

    @Override
    public void mergeFrom(Input input, QueryResult message) throws IOException {
        int number = input.readFieldNumber(this);
        while (true) {
            switch (number) {
                case 0: {
                    return;
                }
                case 1: {
                    message.queryState = QueryState.valueOf(input.readEnum());
                    break;
                }
                case 2: {
                    message.queryId = input.mergeObject(message.queryId, QueryId.getSchema());
                    break;
                }
                case 3: {
                    message.isLastChunk = input.readBool();
                    break;
                }
                case 4: {
                    message.rowCount = input.readInt32();
                    break;
                }
                case 5: {
                    message.recordsScan = input.readInt64();
                    break;
                }
                case 6: {
                    message.recordsError = input.readInt64();
                    break;
                }
                case 7: {
                    message.submissionTime = input.readInt64();
                    break;
                }
                case 8: {
                    if (message.nodeStatus == null) {
                        message.nodeStatus = new ArrayList<NodeStatus>();
                    }
                    message.nodeStatus.add(input.mergeObject(null, NodeStatus.getSchema()));
                    break;
                }
                case 9: {
                    if (message.error == null) {
                        message.error = new ArrayList<DrillPBError>();
                    }
                    message.error.add(input.mergeObject(null, DrillPBError.getSchema()));
                    break;
                }
                case 10: {
                    message.def = input.mergeObject(message.def, RecordBatchDef.getSchema());
                    break;
                }
                case 11: {
                    message.schemaChanged = input.readBool();
                    break;
                }
                default: {
                    input.handleUnknownField(number, this);
                }
            }
            number = input.readFieldNumber(this);
        }
    }

    @Override
    public void writeTo(Output output, QueryResult message) throws IOException {
        if (message.queryState != null) {
            output.writeEnum(1, message.queryState.number, false);
        }
        if (message.queryId != null) {
            output.writeObject(2, message.queryId, QueryId.getSchema(), false);
        }
        if (message.isLastChunk != null) {
            output.writeBool(3, message.isLastChunk, false);
        }
        if (message.rowCount != 0) {
            output.writeInt32(4, message.rowCount, false);
        }
        if (message.recordsScan != 0L) {
            output.writeInt64(5, message.recordsScan, false);
        }
        if (message.recordsError != 0L) {
            output.writeInt64(6, message.recordsError, false);
        }
        if (message.submissionTime != 0L) {
            output.writeInt64(7, message.submissionTime, false);
        }
        if (message.nodeStatus != null) {
            for (NodeStatus nodeStatus : message.nodeStatus) {
                if (nodeStatus == null) continue;
                output.writeObject(8, nodeStatus, NodeStatus.getSchema(), true);
            }
        }
        if (message.error != null) {
            for (DrillPBError error : message.error) {
                if (error == null) continue;
                output.writeObject(9, error, DrillPBError.getSchema(), true);
            }
        }
        if (message.def != null) {
            output.writeObject(10, message.def, RecordBatchDef.getSchema(), false);
        }
        if (message.schemaChanged != null) {
            output.writeBool(11, message.schemaChanged, false);
        }
    }

    @Override
    public String getFieldName(int number) {
        switch (number) {
            case 1: {
                return "queryState";
            }
            case 2: {
                return "queryId";
            }
            case 3: {
                return "isLastChunk";
            }
            case 4: {
                return "rowCount";
            }
            case 5: {
                return "recordsScan";
            }
            case 6: {
                return "recordsError";
            }
            case 7: {
                return "submissionTime";
            }
            case 8: {
                return "nodeStatus";
            }
            case 9: {
                return "error";
            }
            case 10: {
                return "def";
            }
            case 11: {
                return "schemaChanged";
            }
        }
        return null;
    }

    @Override
    public int getFieldNumber(String name) {
        Integer number = __fieldMap.get(name);
        return number == null ? 0 : number;
    }

    static {
        __fieldMap.put("queryState", 1);
        __fieldMap.put("queryId", 2);
        __fieldMap.put("isLastChunk", 3);
        __fieldMap.put("rowCount", 4);
        __fieldMap.put("recordsScan", 5);
        __fieldMap.put("recordsError", 6);
        __fieldMap.put("submissionTime", 7);
        __fieldMap.put("nodeStatus", 8);
        __fieldMap.put("error", 9);
        __fieldMap.put("def", 10);
        __fieldMap.put("schemaChanged", 11);
    }

    public static enum QueryState {
        PENDING(0),
        RUNNING(1),
        COMPLETED(2),
        CANCELED(3),
        FAILED(4),
        UNKNOWN_QUERY(5);

        public final int number;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private QueryState() {
            void number;
            this.number = number;
        }

        public int getNumber() {
            return this.number;
        }

        public static QueryState valueOf(int number) {
            switch (number) {
                case 0: {
                    return PENDING;
                }
                case 1: {
                    return RUNNING;
                }
                case 2: {
                    return COMPLETED;
                }
                case 3: {
                    return CANCELED;
                }
                case 4: {
                    return FAILED;
                }
                case 5: {
                    return UNKNOWN_QUERY;
                }
            }
            return null;
        }
    }
}

