/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.optiq.tools.Planner;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.ViewHandler;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;

public class SqlDropView
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("DROP_VIEW", SqlKind.OTHER){

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlDropView(pos, (SqlIdentifier)operands[0]);
        }
    };
    private SqlIdentifier viewName;

    public SqlDropView(SqlParserPos pos, SqlIdentifier viewName) {
        super(pos);
        this.viewName = viewName;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return Collections.singletonList(this.viewName);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("DROP");
        writer.keyword("VIEW");
        this.viewName.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(Planner planner, QueryContext context) {
        return new ViewHandler.DropView(context);
    }

    public List<String> getSchemaPath() {
        if (this.viewName.isSimple()) {
            return ImmutableList.of();
        }
        return this.viewName.names.subList(0, this.viewName.names.size() - 1);
    }

    public String getName() {
        if (this.viewName.isSimple()) {
            return this.viewName.getSimple();
        }
        return (String)this.viewName.names.get(this.viewName.names.size() - 1);
    }
}

