/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.tools.Planner;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.ViewHandler;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSpecialOperator;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;

public class SqlCreateView
extends DrillSqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("CREATE_VIEW", SqlKind.OTHER){

        @Override
        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlCreateView(pos, (SqlIdentifier)operands[0], (SqlNodeList)operands[1], operands[2], (SqlLiteral)operands[3]);
        }
    };
    private SqlIdentifier viewName;
    private SqlNodeList fieldList;
    private SqlNode query;
    private boolean replaceView;

    public SqlCreateView(SqlParserPos pos, SqlIdentifier viewName, SqlNodeList fieldList, SqlNode query, SqlLiteral replaceView) {
        this(pos, viewName, fieldList, query, replaceView.booleanValue());
    }

    public SqlCreateView(SqlParserPos pos, SqlIdentifier viewName, SqlNodeList fieldList, SqlNode query, boolean replaceView) {
        super(pos);
        this.viewName = viewName;
        this.query = query;
        this.replaceView = replaceView;
        this.fieldList = fieldList;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        ArrayList<SqlNode> ops = Lists.newArrayList();
        ops.add(this.viewName);
        ops.add(this.fieldList);
        ops.add(this.query);
        ops.add(SqlLiteral.createBoolean(this.replaceView, SqlParserPos.ZERO));
        return ops;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("CREATE");
        if (this.replaceView) {
            writer.keyword("OR");
            writer.keyword("REPLACE");
        }
        writer.keyword("VIEW");
        this.viewName.unparse(writer, leftPrec, rightPrec);
        if (this.fieldList != null && this.fieldList.size() > 0) {
            writer.keyword("(");
            this.fieldList.get(0).unparse(writer, leftPrec, rightPrec);
            for (int i = 1; i < this.fieldList.size(); ++i) {
                writer.keyword(",");
                this.fieldList.get(i).unparse(writer, leftPrec, rightPrec);
            }
            writer.keyword(")");
        }
        writer.keyword("AS");
        this.query.unparse(writer, leftPrec, rightPrec);
    }

    @Override
    public AbstractSqlHandler getSqlHandler(Planner planner, QueryContext context) {
        return new ViewHandler.CreateView(planner, context);
    }

    public List<String> getSchemaPath() {
        if (this.viewName.isSimple()) {
            return ImmutableList.of();
        }
        return this.viewName.names.subList(0, this.viewName.names.size() - 1);
    }

    public String getName() {
        if (this.viewName.isSimple()) {
            return this.viewName.getSimple();
        }
        return (String)this.viewName.names.get(this.viewName.names.size() - 1);
    }

    public List<String> getFieldNames() {
        if (this.fieldList == null) {
            return ImmutableList.of();
        }
        ArrayList<String> fieldNames = Lists.newArrayList();
        for (SqlNode node : this.fieldList.getList()) {
            fieldNames.add(node.toString());
        }
        return fieldNames;
    }

    public SqlNode getQuery() {
        return this.query;
    }

    public boolean getReplace() {
        return this.replaceView;
    }
}

