/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.parser;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eigenbase.sql.SqlBasicCall;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillCompoundIdentifier
extends SqlIdentifier {
    List<IdentifierHolder> ids;
    static final Logger logger = LoggerFactory.getLogger(DrillCompoundIdentifier.class);

    private static List<String> getNames(List<IdentifierHolder> identifiers) {
        ArrayList<String> names = Lists.newArrayListWithCapacity(identifiers.size());
        for (IdentifierHolder h : identifiers) {
            names.add(h.value);
        }
        return names;
    }

    public DrillCompoundIdentifier(List<IdentifierHolder> identifiers) {
        super(DrillCompoundIdentifier.getNames(identifiers), identifiers.get((int)0).parserPos);
        this.ids = identifiers;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public SqlNode getAsSqlNode() {
        SqlNode node;
        int startIndex;
        if (this.ids.size() == 1) {
            return new SqlIdentifier(Collections.singletonList(this.ids.get((int)0).value), this.ids.get((int)0).parserPos);
        }
        if (this.ids.get(1).isArray()) {
            startIndex = 1;
            node = new SqlIdentifier(ImmutableList.of(this.ids.get((int)0).value), null, this.ids.get((int)0).parserPos, ImmutableList.of(this.ids.get((int)0).parserPos));
        } else {
            startIndex = 2;
            node = new SqlIdentifier(ImmutableList.of(this.ids.get((int)0).value, this.ids.get((int)1).value), null, this.ids.get((int)0).parserPos, ImmutableList.of(this.ids.get((int)0).parserPos, this.ids.get((int)1).parserPos));
        }
        for (int i = startIndex; i < this.ids.size(); ++i) {
            node = this.ids.get(i).getNode(node);
        }
        return node;
    }

    public SqlNode getAsCompoundIdentifier() {
        ArrayList<String> names = Lists.newArrayListWithCapacity(this.ids.size());
        ArrayList<SqlParserPos> pos = Lists.newArrayListWithCapacity(this.ids.size());
        for (int i = 0; i < this.ids.size(); ++i) {
            IdentifierHolder holder = this.ids.get(i);
            names.add(holder.value);
            pos.add(holder.parserPos);
        }
        return new SqlIdentifier(names, null, (SqlParserPos)pos.get(0), pos);
    }

    private static class IdentifierHolder {
        String value;
        SqlParserPos parserPos;
        boolean isArray;

        public IdentifierHolder(String value, SqlParserPos parserPos, boolean isArray) {
            this.isArray = isArray;
            this.value = value;
            this.parserPos = parserPos;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public SqlNode getNode(SqlNode node) {
            SqlLiteral literal = this.isArray ? SqlLiteral.createExactNumeric(this.value, this.parserPos) : SqlLiteral.createCharString(this.value, this.parserPos);
            return new SqlBasicCall(SqlStdOperatorTable.ITEM, new SqlNode[]{node, literal}, this.parserPos);
        }
    }

    public static class Builder {
        private List<IdentifierHolder> identifiers = Lists.newArrayList();

        public DrillCompoundIdentifier build() {
            return new DrillCompoundIdentifier(this.identifiers);
        }

        public void addString(String name, SqlParserPos pos) {
            this.identifiers.add(new IdentifierHolder(name, pos, false));
        }

        public void addIndex(int index, SqlParserPos pos) {
            this.identifiers.add(new IdentifierHolder(Integer.toString(index), pos, true));
        }
    }
}

