/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.exec.dotdrill.View;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.parser.SqlCreateView;
import org.apache.drill.exec.planner.sql.parser.SqlDropView;
import org.apache.drill.exec.planner.types.DrillFixedRelDataTypeImpl;
import org.apache.drill.exec.store.AbstractSchema;
import org.apache.drill.exec.store.dfs.WorkspaceSchemaFactory;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.sql.SqlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ViewHandler
extends AbstractSqlHandler {
    static final Logger logger = LoggerFactory.getLogger(ViewHandler.class);
    protected Planner planner;
    protected QueryContext context;

    public ViewHandler(Planner planner, QueryContext context) {
        this.planner = planner;
        this.context = context;
    }

    public static class DropView
    extends ViewHandler {
        public DropView(QueryContext context) {
            super(null, context);
        }

        @Override
        public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException {
            SqlDropView dropView = DropView.unwrap(sqlNode, SqlDropView.class);
            try {
                SchemaPlus schema = DropView.findSchema(this.context.getRootSchema(), this.context.getNewDefaultSchema(), dropView.getSchemaPath());
                AbstractSchema drillSchema = DropView.getDrillSchema(schema);
                String schemaPath = drillSchema.getFullSchemaName();
                if (!drillSchema.isMutable()) {
                    return DirectPlan.createDirectPlan(this.context, false, String.format("Schema '%s' is not a mutable schema. Views don't exist in this schema", schemaPath));
                }
                if (!(drillSchema instanceof WorkspaceSchemaFactory.WorkspaceSchema)) {
                    return DirectPlan.createDirectPlan(this.context, false, "Schema provided was not a workspace schema.");
                }
                ((WorkspaceSchemaFactory.WorkspaceSchema)drillSchema).dropView(dropView.getName());
                return DirectPlan.createDirectPlan(this.context, true, String.format("View '%s' deleted successfully from '%s' schema", dropView.getName(), schemaPath));
            }
            catch (Exception e) {
                logger.debug("Failed to delete view {}", (Object)dropView.getName(), (Object)e);
                return DirectPlan.createDirectPlan(this.context, false, String.format("Error: %s", e.getMessage()));
            }
        }
    }

    public static class CreateView
    extends ViewHandler {
        public CreateView(Planner planner, QueryContext context) {
            super(planner, context);
        }

        @Override
        public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException {
            SqlCreateView createView = CreateView.unwrap(sqlNode, SqlCreateView.class);
            try {
                SchemaPlus defaultSchema = this.context.getNewDefaultSchema();
                SchemaPlus schema = CreateView.findSchema(this.context.getRootSchema(), defaultSchema, createView.getSchemaPath());
                AbstractSchema drillSchema = CreateView.getDrillSchema(schema);
                String schemaPath = drillSchema.getFullSchemaName();
                if (!drillSchema.isMutable()) {
                    return DirectPlan.createDirectPlan(this.context, false, String.format("Unable to create view. Schema [%s] is immutable. ", schemaPath));
                }
                ImmutableList<String> workspaceSchemaPath = ImmutableList.of();
                if (!CreateView.isRootSchema(defaultSchema)) {
                    workspaceSchemaPath = CreateView.getDrillSchema(defaultSchema).getSchemaPath();
                }
                String viewSql = createView.getQuery().toString();
                SqlNode validatedQuery = this.planner.validate(createView.getQuery());
                RelNode validatedRelNode = this.planner.convert(validatedQuery);
                RelDataType queryRowType = validatedRelNode.getRowType();
                List<String> viewFieldNames = createView.getFieldNames();
                if (viewFieldNames.size() > 0) {
                    if (viewFieldNames.size() != queryRowType.getFieldCount()) {
                        return DirectPlan.createDirectPlan(this.context, false, "View's field list and View's query field list have different counts.");
                    }
                    for (String field : queryRowType.getFieldNames()) {
                        if (!field.equals("*")) continue;
                        return DirectPlan.createDirectPlan(this.context, false, "View's query field list has a '*', which is invalid when View's field list is specified.");
                    }
                    queryRowType = new DrillFixedRelDataTypeImpl(this.planner.getTypeFactory(), viewFieldNames);
                }
                View view = new View(createView.getName(), viewSql, queryRowType, workspaceSchemaPath);
                if (drillSchema instanceof WorkspaceSchemaFactory.WorkspaceSchema) {
                    WorkspaceSchemaFactory.WorkspaceSchema workspaceSchema = (WorkspaceSchemaFactory.WorkspaceSchema)drillSchema;
                    if (!createView.getReplace() && workspaceSchema.viewExists(view.getName())) {
                        return DirectPlan.createDirectPlan(this.context, false, "View with given name already exists in current schema");
                    }
                } else {
                    return DirectPlan.createDirectPlan(this.context, false, "Schema provided was not a workspace schema.");
                }
                boolean replaced = ((WorkspaceSchemaFactory.WorkspaceSchema)drillSchema).createView(view);
                String summary = String.format("View '%s' %s successfully in '%s' schema", createView.getName(), replaced ? "replaced" : "created", schemaPath);
                return DirectPlan.createDirectPlan(this.context, true, summary);
            }
            catch (Exception e) {
                logger.error("Failed to create view '{}'", (Object)createView.getName(), (Object)e);
                return DirectPlan.createDirectPlan(this.context, false, String.format("Error: %s", e.getMessage()));
            }
        }
    }
}

