/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.parser.SqlUseSchema;
import org.eigenbase.sql.SqlNode;

public class UseSchemaHandler
extends AbstractSqlHandler {
    QueryContext context;

    public UseSchemaHandler(QueryContext context) {
        this.context = context;
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException {
        SqlUseSchema useSchema = UseSchemaHandler.unwrap(sqlNode, SqlUseSchema.class);
        String defaultSchema = useSchema.getSchema();
        boolean status = this.context.getSession().setDefaultSchemaPath(defaultSchema, this.context.getRootSchema());
        String msg = status ? String.format("Default schema changed to '%s'", defaultSchema) : String.format("Failed to change default schema to '%s'", defaultSchema);
        return DirectPlan.createDirectPlan(this.context, status, msg);
    }
}

