/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RelConversionException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.parser.DrillParserUtil;
import org.apache.drill.exec.planner.sql.parser.SqlShowTables;
import org.apache.drill.exec.store.AbstractSchema;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;

public class ShowTablesHandler
extends DefaultSqlHandler {
    public ShowTablesHandler(Planner planner, QueryContext context) {
        super(planner, context);
    }

    @Override
    public SqlNode rewrite(SqlNode sqlNode) throws RelConversionException {
        String tableSchema;
        SqlShowTables node = ShowTablesHandler.unwrap(sqlNode, SqlShowTables.class);
        ArrayList<SqlIdentifier> selectList = Lists.newArrayList();
        selectList.add(new SqlIdentifier("TABLE_SCHEMA", SqlParserPos.ZERO));
        selectList.add(new SqlIdentifier("TABLE_NAME", SqlParserPos.ZERO));
        SqlIdentifier fromClause = new SqlIdentifier(ImmutableList.of("INFORMATION_SCHEMA", "TABLES"), SqlParserPos.ZERO);
        SqlIdentifier db = node.getDb();
        if (db != null) {
            tableSchema = db.toString();
        } else {
            AbstractSchema drillSchema;
            SchemaPlus schema = this.context.getNewDefaultSchema();
            if (ShowTablesHandler.isRootSchema(schema)) {
                throw new RelConversionException("No schema selected. Select a schema using 'USE schema' command");
            }
            try {
                drillSchema = ShowTablesHandler.getDrillSchema(schema);
            }
            catch (Exception ex) {
                throw new RelConversionException("Error while rewriting SHOW TABLES query: " + ex.getMessage(), ex);
            }
            tableSchema = drillSchema.getFullSchemaName();
        }
        SqlNode where = DrillParserUtil.createCondition(new SqlIdentifier("TABLE_SCHEMA", SqlParserPos.ZERO), SqlStdOperatorTable.EQUALS, SqlLiteral.createCharString(tableSchema, "ISO-8859-1", SqlParserPos.ZERO));
        SqlNode filter = null;
        SqlNode likePattern = node.getLikePattern();
        if (likePattern != null) {
            filter = DrillParserUtil.createCondition(new SqlIdentifier("TABLE_NAME", SqlParserPos.ZERO), SqlStdOperatorTable.LIKE, likePattern);
        } else if (node.getWhereClause() != null) {
            filter = node.getWhereClause();
        }
        where = DrillParserUtil.createCondition(where, SqlStdOperatorTable.AND, filter);
        return new SqlSelect(SqlParserPos.ZERO, null, new SqlNodeList(selectList, SqlParserPos.ZERO), fromClause, where, null, null, null, null, null, null);
    }
}

