/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import java.io.IOException;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.sql.DirectPlan;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.server.options.OptionValue;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlSetOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetOptionHandler
extends AbstractSqlHandler {
    static final Logger logger = LoggerFactory.getLogger(SetOptionHandler.class);
    QueryContext context;

    public SetOptionHandler(QueryContext context) {
        this.context = context;
    }

    @Override
    public PhysicalPlan getPlan(SqlNode sqlNode) throws ValidationException, RelConversionException, IOException {
        OptionValue.OptionType type;
        SqlSetOption option = SetOptionHandler.unwrap(sqlNode, SqlSetOption.class);
        String scope = option.getScope();
        String name = option.getName();
        SqlNode value = option.getValue();
        if (value instanceof SqlLiteral) {
            switch (scope.toLowerCase()) {
                case "session": {
                    type = OptionValue.OptionType.SESSION;
                    break;
                }
                case "system": {
                    type = OptionValue.OptionType.SYSTEM;
                    break;
                }
                default: {
                    throw new ValidationException("Invalid OPTION scope. Scope must be SESSION or SYSTEM.");
                }
            }
        } else {
            throw new ValidationException("Sql options can only be literals.");
        }
        this.context.getOptions().setOption(name, (SqlLiteral)value, type);
        return DirectPlan.createDirectPlan(this.context, true, String.format("%s updated.", name));
    }
}

