/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.google.common.collect.ImmutableList;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RelConversionException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.parser.DrillParserUtil;
import org.apache.drill.exec.planner.sql.parser.SqlDescribeTable;
import org.apache.drill.exec.store.AbstractSchema;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.fun.SqlStdOperatorTable;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.util.Util;

public class DescribeTableHandler
extends DefaultSqlHandler {
    public DescribeTableHandler(Planner planner, QueryContext context) {
        super(planner, context);
    }

    @Override
    public SqlNode rewrite(SqlNode sqlNode) throws RelConversionException {
        SqlDescribeTable node = DescribeTableHandler.unwrap(sqlNode, SqlDescribeTable.class);
        try {
            ImmutableList<SqlIdentifier> selectList = ImmutableList.of(new SqlIdentifier("COLUMN_NAME", SqlParserPos.ZERO), new SqlIdentifier("DATA_TYPE", SqlParserPos.ZERO), new SqlIdentifier("IS_NULLABLE", SqlParserPos.ZERO));
            SqlIdentifier fromClause = new SqlIdentifier(ImmutableList.of("INFORMATION_SCHEMA", "COLUMNS"), null, SqlParserPos.ZERO, null);
            SqlIdentifier table = node.getTable();
            SchemaPlus schema = DescribeTableHandler.findSchema(this.context.getRootSchema(), this.context.getNewDefaultSchema(), Util.skipLast(table.names));
            String tableName = Util.last(table.names);
            if (schema.getTable(tableName) == null) {
                throw new RelConversionException(String.format("Table %s is not valid", Util.sepList(table.names, ".")));
            }
            SqlNode schemaCondition = null;
            if (!DescribeTableHandler.isRootSchema(schema)) {
                AbstractSchema drillSchema = DescribeTableHandler.getDrillSchema(schema);
                schemaCondition = DrillParserUtil.createCondition(new SqlIdentifier("TABLE_SCHEMA", SqlParserPos.ZERO), SqlStdOperatorTable.EQUALS, SqlLiteral.createCharString(drillSchema.getFullSchemaName(), "ISO-8859-1", SqlParserPos.ZERO));
            }
            SqlNode where = DrillParserUtil.createCondition(new SqlIdentifier("TABLE_NAME", SqlParserPos.ZERO), SqlStdOperatorTable.EQUALS, SqlLiteral.createCharString(tableName, "ISO-8859-1", SqlParserPos.ZERO));
            where = DrillParserUtil.createCondition(schemaCondition, SqlStdOperatorTable.AND, where);
            SqlNode columnFilter = null;
            if (node.getColumn() != null) {
                columnFilter = DrillParserUtil.createCondition(new SqlIdentifier("COLUMN_NAME", SqlParserPos.ZERO), SqlStdOperatorTable.EQUALS, SqlLiteral.createCharString(node.getColumn().toString(), "ISO-8859-1", SqlParserPos.ZERO));
            } else if (node.getColumnQualifier() != null) {
                columnFilter = DrillParserUtil.createCondition(new SqlIdentifier("COLUMN_NAME", SqlParserPos.ZERO), SqlStdOperatorTable.LIKE, node.getColumnQualifier());
            }
            where = DrillParserUtil.createCondition(where, SqlStdOperatorTable.AND, columnFilter);
            return new SqlSelect(SqlParserPos.ZERO, null, new SqlNodeList(selectList, SqlParserPos.ZERO), fromClause, where, null, null, null, null, null, null);
        }
        catch (Exception ex) {
            throw new RelConversionException("Error while rewriting DESCRIBE query: " + ex.getMessage(), ex);
        }
    }
}

