/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql.handlers;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.store.AbstractSchema;
import org.eigenbase.sql.SqlNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlHandler {
    static final Logger logger = LoggerFactory.getLogger(AbstractSqlHandler.class);

    public abstract PhysicalPlan getPlan(SqlNode var1) throws ValidationException, RelConversionException, IOException;

    public static <T> T unwrap(Object o, Class<T> clazz) throws RelConversionException {
        if (clazz.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new RelConversionException(String.format("Failure trying to treat %s as type %s.", o.getClass().getSimpleName(), clazz.getSimpleName()));
    }

    public static AbstractSchema getDrillSchema(SchemaPlus schemaPlus) throws Exception {
        AbstractSchema drillSchema;
        try {
            drillSchema = schemaPlus.unwrap(AbstractSchema.class);
            drillSchema = drillSchema.getDefaultSchema();
        }
        catch (ClassCastException e) {
            throw new Exception("Current schema is not a Drill schema. Can't create new relations (tables or views) in non-Drill schemas.", e);
        }
        return drillSchema;
    }

    public static SchemaPlus findSchema(SchemaPlus rootSchema, SchemaPlus defaultSchema, List<String> schemaPath) throws Exception {
        if (schemaPath.size() == 0) {
            return defaultSchema;
        }
        SchemaPlus schema = AbstractSqlHandler.searchSchemaTree(defaultSchema, schemaPath);
        if (schema != null) {
            return schema;
        }
        schema = AbstractSqlHandler.searchSchemaTree(rootSchema, schemaPath);
        if (schema != null) {
            return schema;
        }
        throw new Exception(String.format("Invalid schema path '%s'.", Joiner.on(".").join(schemaPath)));
    }

    public static boolean isRootSchema(SchemaPlus schema) {
        return schema.getParentSchema() == null;
    }

    private static SchemaPlus searchSchemaTree(SchemaPlus schema, List<String> schemaPath) {
        for (String schemaName : schemaPath) {
            if ((schema = schema.getSubSchema(schemaName)) != null) continue;
            return null;
        }
        return schema;
    }
}

