/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.io.IOException;
import java.util.ArrayList;
import net.hydromatic.optiq.config.Lex;
import net.hydromatic.optiq.tools.FrameworkConfig;
import net.hydromatic.optiq.tools.Frameworks;
import net.hydromatic.optiq.tools.Planner;
import net.hydromatic.optiq.tools.RelConversionException;
import net.hydromatic.optiq.tools.RuleSet;
import net.hydromatic.optiq.tools.ValidationException;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.planner.cost.DrillCostBase;
import org.apache.drill.exec.planner.logical.DrillRuleSets;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.sql.DrillConvertletTable;
import org.apache.drill.exec.planner.sql.handlers.AbstractSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.ExplainHandler;
import org.apache.drill.exec.planner.sql.handlers.SetOptionHandler;
import org.apache.drill.exec.planner.sql.parser.DrillSqlCall;
import org.apache.drill.exec.planner.sql.parser.impl.DrillParserWithCompoundIdConverter;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.util.Pointer;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.relopt.ConventionTraitDef;
import org.eigenbase.relopt.RelTraitDef;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.parser.SqlParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillSqlWorker {
    static final Logger logger = LoggerFactory.getLogger(DrillSqlWorker.class);
    private final Planner planner;
    private final QueryContext context;

    public DrillSqlWorker(QueryContext context) throws Exception {
        ArrayList<RelTraitDef> traitDefs = new ArrayList<RelTraitDef>();
        traitDefs.add(ConventionTraitDef.INSTANCE);
        traitDefs.add(DrillDistributionTraitDef.INSTANCE);
        traitDefs.add(RelCollationTraitDef.INSTANCE);
        this.context = context;
        DrillCostBase.DrillCostFactory costFactory = context.getPlannerSettings().useDefaultCosting() ? null : new DrillCostBase.DrillCostFactory();
        FrameworkConfig config = Frameworks.newConfigBuilder().lex(Lex.MYSQL).parserFactory(DrillParserWithCompoundIdConverter.FACTORY).defaultSchema(context.getNewDefaultSchema()).operatorTable(context.getDrillOperatorTable()).traitDefs(traitDefs).convertletTable(new DrillConvertletTable()).context(context.getPlannerSettings()).ruleSets(this.getRules(context)).costFactory(costFactory).build();
        this.planner = Frameworks.getPlanner(config);
    }

    private RuleSet[] getRules(QueryContext context) {
        StoragePluginRegistry storagePluginRegistry = context.getStorage();
        RuleSet drillPhysicalMem = DrillRuleSets.mergedRuleSets(DrillRuleSets.getPhysicalRules(context), storagePluginRegistry.getStoragePluginRuleSet());
        RuleSet[] allRules = new RuleSet[]{DrillRuleSets.getDrillBasicRules(context), drillPhysicalMem};
        return allRules;
    }

    public PhysicalPlan getPlan(String sql, Pointer<String> textPlan) throws SqlParseException, ValidationException, RelConversionException, IOException {
        AbstractSqlHandler handler;
        SqlNode sqlNode = this.planner.parse(sql);
        switch (sqlNode.getKind()) {
            case EXPLAIN: {
                handler = new ExplainHandler(this.planner, this.context);
                break;
            }
            case SET_OPTION: {
                handler = new SetOptionHandler(this.context);
                break;
            }
            case OTHER: {
                if (sqlNode instanceof DrillSqlCall) {
                    handler = ((DrillSqlCall)sqlNode).getSqlHandler(this.planner, this.context);
                    break;
                }
            }
            default: {
                handler = new DefaultSqlHandler(this.planner, this.context, textPlan);
            }
        }
        return ((AbstractSqlHandler)handler).getPlan(sqlNode);
    }
}

