/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.sql;

import java.util.Collections;
import java.util.Iterator;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.config.Screen;
import org.apache.drill.exec.planner.sql.handlers.DefaultSqlHandler;
import org.apache.drill.exec.planner.sql.handlers.SimpleCommandResult;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.store.direct.DirectGroupScan;
import org.apache.drill.exec.store.pojo.PojoRecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectPlan {
    static final Logger logger = LoggerFactory.getLogger(DirectPlan.class);

    public static PhysicalPlan createDirectPlan(QueryContext context, boolean result, String message) {
        return DirectPlan.createDirectPlan(context, new SimpleCommandResult(result, message));
    }

    public static <T> PhysicalPlan createDirectPlan(QueryContext context, T obj) {
        Iterator<T> iter = Collections.singleton(obj).iterator();
        return DirectPlan.createDirectPlan(context.getCurrentEndpoint(), iter, obj.getClass());
    }

    public static <T> PhysicalPlan createDirectPlan(CoordinationProtos.DrillbitEndpoint endpoint, Iterator<T> iterator, Class<T> clazz) {
        PojoRecordReader<T> reader = new PojoRecordReader<T>(clazz, iterator);
        DirectGroupScan scan = new DirectGroupScan(reader);
        Screen screen = new Screen(scan, endpoint);
        PlanProperties.PlanPropertiesBuilder propsBuilder = PlanProperties.builder();
        propsBuilder.type(PlanProperties.PlanType.APACHE_DRILL_PHYSICAL);
        propsBuilder.version(1);
        propsBuilder.resultMode(PlanProperties.Generator.ResultMode.EXEC);
        propsBuilder.generator(DirectPlan.class.getSimpleName(), "");
        return new PhysicalPlan(propsBuilder.build(), DefaultSqlHandler.getPops(screen));
    }
}

