/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.drill.exec.planner.StarColumnHelper;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectAllowDupPrel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;
import org.eigenbase.util.Pair;

public class StarColumnConverter
extends BasePrelVisitor<Prel, boolean[], RuntimeException> {
    private static StarColumnConverter INSTANCE = new StarColumnConverter();
    private static final AtomicLong tableNumber = new AtomicLong(0L);

    public static Prel insertRenameProject(Prel root, RelDataType origRowType) {
        boolean[] renamedForStar = new boolean[]{false, false};
        Prel child = ((Prel)root.getInput(0)).accept(INSTANCE, renamedForStar);
        if (renamedForStar[0] && renamedForStar[1]) {
            ArrayList<RexNode> exprs = Lists.newArrayList();
            for (int i = 0; i < origRowType.getFieldCount(); ++i) {
                RexInputRef expr = child.getCluster().getRexBuilder().makeInputRef(origRowType.getFieldList().get(i).getType(), i);
                exprs.add(expr);
            }
            RelDataType newRowType = RexUtil.createStructType(child.getCluster().getTypeFactory(), exprs, origRowType.getFieldNames());
            child = new ProjectAllowDupPrel(child.getCluster(), child.getTraitSet(), child, exprs, newRowType);
            ArrayList<RelNode> children = Lists.newArrayList();
            children.add(child);
            return (Prel)root.copy(root.getTraitSet(), children);
        }
        return root;
    }

    @Override
    public Prel visitPrel(Prel prel, boolean[] renamedForStar) throws RuntimeException {
        ArrayList<RelNode> children = Lists.newArrayList();
        for (Prel child : prel) {
            child = child.accept(this, renamedForStar);
            children.add(child);
        }
        if (prel instanceof ProjectPrel) {
            RelNode child = (RelNode)children.get(0);
            List<String> fieldNames = Lists.newArrayList();
            for (Pair<String, RexNode> pair : Pair.zip(prel.getRowType().getFieldNames(), ((ProjectPrel)prel).getProjects())) {
                if (pair.right instanceof RexInputRef) {
                    String name = child.getRowType().getFieldNames().get(((RexInputRef)pair.right).getIndex());
                    fieldNames.add(name);
                    continue;
                }
                fieldNames.add((String)pair.left);
            }
            fieldNames = this.makeUniqueNames(fieldNames);
            RelDataType rowType = RexUtil.createStructType(prel.getCluster().getTypeFactory(), ((ProjectPrel)prel).getProjects(), fieldNames);
            return new ProjectPrel(prel.getCluster(), prel.getTraitSet(), (RelNode)children.get(0), ((ProjectPrel)prel).getProjects(), rowType);
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    @Override
    public Prel visitJoin(JoinPrel prel, boolean[] renamedForStar) throws RuntimeException {
        renamedForStar[0] = true;
        return this.visitPrel((Prel)prel, renamedForStar);
    }

    @Override
    public Prel visitScan(ScanPrel scanPrel, boolean[] renamedForStar) throws RuntimeException {
        if (StarColumnHelper.containsStarColumn(scanPrel.getRowType()) && renamedForStar[0]) {
            renamedForStar[1] = true;
            ArrayList<RexNode> exprs = Lists.newArrayList();
            for (RelDataTypeField field : scanPrel.getRowType().getFieldList()) {
                RexInputRef expr = scanPrel.getCluster().getRexBuilder().makeInputRef(field.getType(), field.getIndex());
                exprs.add(expr);
            }
            ArrayList<String> fieldNames = Lists.newArrayList();
            long tableId = tableNumber.getAndIncrement();
            for (String name : scanPrel.getRowType().getFieldNames()) {
                fieldNames.add("T" + tableId + "\u00a6\u00a6" + name);
            }
            RelDataType rowType = RexUtil.createStructType(scanPrel.getCluster().getTypeFactory(), exprs, fieldNames);
            ProjectPrel proj = new ProjectPrel(scanPrel.getCluster(), scanPrel.getTraitSet(), scanPrel, exprs, rowType);
            return proj;
        }
        return this.visitPrel((Prel)scanPrel, renamedForStar);
    }

    private List<String> makeUniqueNames(List<String> names) {
        HashSet<String> uniqueNames = new HashSet<String>();
        HashSet<String> origNames = new HashSet<String>(names);
        ArrayList<String> newNames = Lists.newArrayList();
        for (String s : names) {
            if (uniqueNames.contains(s)) {
                int i = 0;
                while (origNames.contains(s = s + i) || uniqueNames.contains(s)) {
                    ++i;
                }
            }
            uniqueNames.add(s);
            newNames.add(s);
        }
        return newNames;
    }
}

