/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.ScreenPrel;
import org.apache.drill.exec.planner.physical.WriterPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.eigenbase.rel.RelNode;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalColumnReorderer
extends BasePrelVisitor<Prel, Void, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(FinalColumnReorderer.class);
    private static FinalColumnReorderer INSTANCE = new FinalColumnReorderer();

    public static Prel addFinalColumnOrdering(Prel prel) {
        return prel.accept(INSTANCE, null);
    }

    @Override
    public Prel visitScreen(ScreenPrel prel, Void value) throws RuntimeException {
        Prel newChild = ((Prel)prel.getChild()).accept(this, value);
        return prel.copy(prel.getTraitSet(), Collections.singletonList(this.addTrivialOrderedProjectPrel(newChild)));
    }

    private Prel addTrivialOrderedProjectPrel(Prel prel) {
        if (!prel.needsFinalColumnReordering()) {
            return prel;
        }
        RelDataType t = prel.getRowType();
        RexBuilder b = prel.getCluster().getRexBuilder();
        ArrayList<RexNode> projections = Lists.newArrayList();
        int projectCount = t.getFieldList().size();
        if (projectCount < 2) {
            return prel;
        }
        for (int i = 0; i < projectCount; ++i) {
            projections.add(b.makeInputRef(prel, i));
        }
        return new ProjectPrel(prel.getCluster(), prel.getTraitSet(), prel, projections, prel.getRowType());
    }

    @Override
    public Prel visitWriter(WriterPrel prel, Void value) throws RuntimeException {
        Prel newChild = ((Prel)prel.getChild()).accept(this, null);
        return prel.copy(prel.getTraitSet(), Collections.singletonList(this.addTrivialOrderedProjectPrel(newChild)));
    }

    @Override
    public Prel visitPrel(Prel prel, Void value) throws RuntimeException {
        ArrayList<RelNode> children = Lists.newArrayList();
        boolean changed = false;
        for (Prel p : prel) {
            Prel newP = p.accept(this, null);
            if (newP != p) {
                changed = true;
            }
            children.add(newP);
        }
        if (changed) {
            return (Prel)prel.copy(prel.getTraitSet(), children);
        }
        return prel;
    }
}

