/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.visitor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.planner.physical.ScreenPrel;
import org.apache.drill.exec.planner.physical.visitor.BasePrelVisitor;
import org.eigenbase.rel.RelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcessiveExchangeIdentifier
extends BasePrelVisitor<Prel, MajorFragmentStat, RuntimeException> {
    static final Logger logger = LoggerFactory.getLogger(ExcessiveExchangeIdentifier.class);
    private final long targetSliceSize;

    public ExcessiveExchangeIdentifier(long targetSliceSize) {
        this.targetSliceSize = targetSliceSize;
    }

    public static Prel removeExcessiveEchanges(Prel prel, long targetSliceSize) {
        ExcessiveExchangeIdentifier exchange = new ExcessiveExchangeIdentifier(targetSliceSize);
        return prel.accept(exchange, exchange.getNewStat());
    }

    @Override
    public Prel visitExchange(ExchangePrel prel, MajorFragmentStat parent) throws RuntimeException {
        parent.add(prel);
        MajorFragmentStat newFrag = new MajorFragmentStat();
        Prel newChild = ((Prel)prel.getChild()).accept(this, newFrag);
        if (newFrag.isSingular() && parent.isSingular()) {
            return newChild;
        }
        return (Prel)prel.copy(prel.getTraitSet(), Collections.singletonList(newChild));
    }

    @Override
    public Prel visitScreen(ScreenPrel prel, MajorFragmentStat s) throws RuntimeException {
        s.setSingular();
        RelNode child = ((Prel)prel.getChild()).accept(this, s);
        return prel.copy(prel.getTraitSet(), (List)Collections.singletonList(child));
    }

    @Override
    public Prel visitScan(ScanPrel prel, MajorFragmentStat s) throws RuntimeException {
        s.addScan(prel);
        return prel;
    }

    @Override
    public Prel visitPrel(Prel prel, MajorFragmentStat s) throws RuntimeException {
        ArrayList<RelNode> children = Lists.newArrayList();
        s.add(prel);
        for (Prel p : prel) {
            children.add(p.accept(this, s));
        }
        return (Prel)prel.copy(prel.getTraitSet(), children);
    }

    public MajorFragmentStat getNewStat() {
        return new MajorFragmentStat();
    }

    class MajorFragmentStat {
        private double maxRows = 0.0;
        private int maxWidth = Integer.MAX_VALUE;

        MajorFragmentStat() {
        }

        public void add(Prel prel) {
            this.maxRows = Math.max(prel.getRows(), this.maxRows);
        }

        public void setSingular() {
            this.maxWidth = 1;
        }

        public void addScan(ScanPrel prel) {
            this.maxWidth = Math.min(this.maxWidth, prel.getGroupScan().getMaxParallelizationWidth());
            this.add(prel);
        }

        public boolean isSingular() {
            int suggestedWidth = (int)Math.ceil((this.maxRows + 1.0) / (double)ExcessiveExchangeIdentifier.this.targetSliceSize);
            int w = Math.min(this.maxWidth, suggestedWidth);
            if (w < 1) {
                w = 1;
            }
            return w == 1;
        }
    }
}

