/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical.explain;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.hydromatic.optiq.runtime.Spacer;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.explain.PrelSequencer;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.RelWriter;
import org.eigenbase.rel.metadata.RelMetadataQuery;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlExplainLevel;
import org.eigenbase.util.Pair;

class NumberingRelWriter
implements RelWriter {
    protected final PrintWriter pw;
    private final SqlExplainLevel detailLevel;
    protected final Spacer spacer = new Spacer();
    private final List<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();
    private final Map<Prel, PrelSequencer.OpId> ids;

    public NumberingRelWriter(Map<Prel, PrelSequencer.OpId> ids, PrintWriter pw, SqlExplainLevel detailLevel) {
        this.pw = pw;
        this.ids = ids;
        this.detailLevel = detailLevel;
    }

    protected void explain_(RelNode rel, List<Pair<String, Object>> values) {
        List<RelNode> inputs = rel.getInputs();
        if (!RelMetadataQuery.isVisibleInExplain(rel, this.detailLevel)) {
            this.explainInputs(inputs);
            return;
        }
        StringBuilder s = new StringBuilder();
        PrelSequencer.OpId id = this.ids.get(rel);
        s.append(String.format("%02d-%02d", id.fragmentId, id.opId));
        s.append("  ");
        if (id.opId == 0) {
            for (int i = 0; i < this.spacer.get(); ++i) {
                s.append('-');
            }
        } else {
            this.spacer.spaces(s);
        }
        s.append("  ");
        s.append(rel.getRelTypeName().replace("Prel", ""));
        if (this.detailLevel != SqlExplainLevel.NO_ATTRIBUTES) {
            int j = 0;
            for (Pair<String, Object> value : values) {
                if (value.right instanceof RelNode) continue;
                if (j++ == 0) {
                    s.append("(");
                } else {
                    s.append(", ");
                }
                s.append((String)value.left).append("=[").append(value.right).append("]");
            }
            if (j > 0) {
                s.append(")");
            }
        }
        if (this.detailLevel == SqlExplainLevel.ALL_ATTRIBUTES) {
            s.append(": rowcount = ").append(RelMetadataQuery.getRowCount(rel)).append(", cumulative cost = ").append(RelMetadataQuery.getCumulativeCost(rel));
            s.append(", id = ").append(rel.getId());
        }
        this.pw.println(s);
        this.spacer.add(2);
        this.explainInputs(inputs);
        this.spacer.subtract(2);
    }

    private void explainInputs(List<RelNode> inputs) {
        for (RelNode input : inputs) {
            input.explain(this);
        }
    }

    @Override
    public SqlExplainLevel getDetailLevel() {
        return this.detailLevel;
    }

    @Override
    public RelWriter input(String term, RelNode input) {
        this.values.add(Pair.of(term, input));
        return this;
    }

    @Override
    public RelWriter item(String term, Object value) {
        this.values.add(Pair.of(term, value));
        return this;
    }

    @Override
    public RelWriter itemIf(String term, Object value, boolean condition) {
        if (condition) {
            this.item(term, value);
        }
        return this;
    }

    @Override
    public RelWriter done(RelNode node) {
        int i = 0;
        if (this.values.size() > 0 && ((String)this.values.get((int)0).left).equals("subset")) {
            ++i;
        }
        for (RelNode input : node.getInputs()) {
            assert (this.values.get((int)i).right == input);
            ++i;
        }
        for (RexNode expr : node.getChildExps()) {
            assert (this.values.get((int)i).right == expr);
            ++i;
        }
        ImmutableList<Pair<String, Object>> valuesCopy = ImmutableList.copyOf(this.values);
        this.values.clear();
        this.explain_(node, valuesCopy);
        this.pw.flush();
        return this;
    }

    @Override
    public boolean nest() {
        return false;
    }
}

